/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.views.freemarker;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sun.jersey.api.container.ContainerException;
import com.yammer.dropwizard.views.View;
import com.yammer.dropwizard.views.ViewRenderer;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import javax.ws.rs.WebApplicationException;

public class FreemarkerViewRenderer
implements ViewRenderer {
    private final LoadingCache<Class<?>, Configuration> configurationCache = CacheBuilder.newBuilder().concurrencyLevel(128).build((CacheLoader)new TemplateLoader());

    @Override
    public boolean isRenderable(View view) {
        return view.getTemplateName().endsWith(".ftl");
    }

    @Override
    public void render(View view, Locale locale, OutputStream output) throws IOException, WebApplicationException {
        try {
            Configuration configuration = (Configuration)this.configurationCache.getUnchecked(view.getClass());
            Template template = configuration.getTemplate(view.getTemplateName(), locale);
            template.process((Object)view, (Writer)new OutputStreamWriter(output, template.getEncoding()));
        }
        catch (TemplateException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    private static class TemplateLoader
    extends CacheLoader<Class<?>, Configuration> {
        private TemplateLoader() {
        }

        public Configuration load(Class<?> key) throws Exception {
            Configuration configuration = new Configuration();
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            configuration.setDefaultEncoding(Charsets.UTF_8.name());
            configuration.setClassForTemplateLoading(key, "/");
            return configuration;
        }
    }
}

