/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.abstractjar.impl;

import com.yworks.util.abstractjar.Archive;
import com.yworks.util.abstractjar.Entry;
import com.yworks.util.abstractjar.impl.JarEntryWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarFileWrapper
implements Archive {
    JarFile jarFile;
    Map<Entry, JarEntry> entries = new HashMap<Entry, JarEntry>();

    public JarFileWrapper(File file) throws IOException {
        this.jarFile = new JarFile(file);
        Enumeration<JarEntry> jarEntryEnumeration = this.jarFile.entries();
        while (jarEntryEnumeration.hasMoreElements()) {
            JarEntry jarEntry = jarEntryEnumeration.nextElement();
            this.entries.put(new JarEntryWrapper(jarEntry), jarEntry);
        }
    }

    @Override
    public String getName() {
        return this.jarFile.getName();
    }

    @Override
    public Enumeration<Entry> getEntries() {
        return Collections.enumeration(this.entries.keySet());
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public InputStream getInputStream(Entry entry) throws IOException {
        return this.jarFile.getInputStream(this.entries.get(entry));
    }

    @Override
    public void close() throws IOException {
        this.jarFile.close();
    }
}

