/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.ant;

import com.yworks.yguard.ObfuscatorTask;
import com.yworks.yguard.ant.ClassSection;
import com.yworks.yguard.ant.FieldSection;
import com.yworks.yguard.ant.MethodSection;
import com.yworks.yguard.ant.PackageSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public final class MapParser
implements ContentHandler {
    private int state;
    private ArrayList entries = new ArrayList(50);
    private Map ownerProperties = new HashMap();
    private final ObfuscatorTask obfuscatorTask;

    public MapParser(ObfuscatorTask obfuscatorTask) {
        this.obfuscatorTask = obfuscatorTask;
    }

    public Collection getEntries() {
        return this.entries;
    }

    Map getOwnerProperties() {
        return this.ownerProperties;
    }

    @Override
    public void characters(char[] values, int param, int param2) {
    }

    @Override
    public void endDocument() {
        this.state = 0;
    }

    @Override
    public void endElement(String str, String str1, String str2) {
        if (this.state == 3 && "map".equals(str2)) {
            this.state = 2;
        }
        if (this.state == 2 && "yguard".equals(str2)) {
            this.state = 1;
        }
    }

    @Override
    public void endPrefixMapping(String str) {
    }

    @Override
    public void ignorableWhitespace(char[] values, int param, int param2) {
    }

    @Override
    public void processingInstruction(String str, String str1) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String str) {
    }

    @Override
    public void startDocument() {
        this.state = 1;
    }

    @Override
    public void startElement(String str, String str1, String str2, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 2: {
                if ("map".equals(str2)) {
                    this.state = 3;
                    break;
                }
                if (!"property".equals(str2)) break;
                String key = attributes.getValue("key");
                String value = attributes.getValue("key");
                String owner = attributes.getValue("owner");
                HashMap<String, String> map = (HashMap<String, String>)this.ownerProperties.get(owner);
                if (map == null) {
                    map = new HashMap<String, String>();
                    this.ownerProperties.put(owner, map);
                }
                map.put(key, value);
                break;
            }
            case 1: {
                if (!"yguard".equals(str2)) break;
                String version = attributes.getValue("version");
                if ("1.0".equals(version) || "1.1".equals(version) || "1.5".equals(version)) {
                    this.state = 2;
                    break;
                }
                throw new SAXNotRecognizedException("Version '" + version + "' of yguard logfile not supported!");
            }
            case 3: {
                if (str2.equals("package")) {
                    PackageSection ps = new PackageSection();
                    ps.setName(attributes.getValue("name"));
                    ps.setMap(attributes.getValue("map"));
                    ps.addMapEntries(this.entries);
                    break;
                }
                if (str2.equals("class")) {
                    ClassSection cs = new ClassSection();
                    cs.setName(attributes.getValue("name"));
                    cs.setMap(attributes.getValue("map"));
                    cs.addMapEntries(this.entries);
                    break;
                }
                if (str2.equals("method")) {
                    MethodSection ms = new MethodSection();
                    ms.setClass(attributes.getValue("class"));
                    ms.setName(attributes.getValue("name"));
                    ms.setMap(attributes.getValue("map"));
                    ms.addMapEntries(this.entries);
                    break;
                }
                if (str2.equals("field")) {
                    FieldSection fs = new FieldSection();
                    fs.setClass(attributes.getValue("class"));
                    fs.setName(attributes.getValue("name"));
                    fs.setMap(attributes.getValue("map"));
                    fs.addMapEntries(this.entries);
                    break;
                }
                throw new SAXNotRecognizedException("Unknown child element " + str2 + " in map element!");
            }
        }
    }

    @Override
    public void startPrefixMapping(String str, String str1) {
    }
}

