/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.ant;

import com.yworks.common.ant.ZipScannerTool;
import com.yworks.yguard.ObfuscatorTask;
import com.yworks.yguard.ant.Mappable;
import com.yworks.yguard.obf.YGuardRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;

public class PackageSection
implements Mappable {
    private String name;
    private String mapTo;
    protected List patternSets = new ArrayList(5);
    protected boolean allowMatchAllPatternSet = false;

    public void addConfiguredPatternSet(PatternSet ps) {
        this.patternSets.add(ps);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addEntries(Collection entries, ZipFileSet zf) throws IOException {
        Project project = zf.getProject();
        HashSet<String> packages = new HashSet<String>();
        if (this.name != null) {
            packages.add(ObfuscatorTask.toNativeClass(this.name));
        }
        for (PatternSet ps : this.patternSets) {
            DirectoryScanner scanner = zf.getDirectoryScanner(project);
            scanner.setIncludes(ObfuscatorTask.toNativePattern(ps.getIncludePatterns(project)));
            scanner.setExcludes(ObfuscatorTask.toNativePattern(ps.getExcludePatterns(project)));
            String[] matches = ZipScannerTool.getMatches(zf, scanner);
            for (int i = 0; i < matches.length; ++i) {
                String match = matches[i];
                int slashIndex = match.lastIndexOf(47);
                if (!match.endsWith(".class") && (!match.endsWith("/") || slashIndex <= 0)) continue;
                match = match.substring(0, slashIndex);
                packages.add(match);
            }
        }
        if (this.patternSets.isEmpty() && this.allowMatchAllPatternSet && this.name == null) {
            DirectoryScanner scanner = zf.getDirectoryScanner(project);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.setExcludes(new String[0]);
            String[] matches = ZipScannerTool.getMatches(zf, scanner);
            for (int i = 0; i < matches.length; ++i) {
                String match = matches[i];
                int slashIndex = match.lastIndexOf(47);
                if (!match.endsWith(".class") && (!match.endsWith("/") || slashIndex <= 0)) continue;
                match = match.substring(0, slashIndex);
                packages.add(match);
            }
        }
        for (String pack : packages) {
            YGuardRule rule = new YGuardRule(11, pack);
            entries.add(rule);
        }
    }

    public void setMap(String mapTo) {
        this.mapTo = mapTo;
    }

    @Override
    public void addMapEntries(Collection entries) {
        YGuardRule entry = new YGuardRule(4, ObfuscatorTask.toNativeClass(this.name));
        entry.obfName = ObfuscatorTask.toNativeClass(this.mapTo);
        entries.add(entry);
    }
}

