/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.obf.NameMaker;
import com.yworks.yguard.obf.Tools;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class KeywordNameMaker
implements NameMaker {
    private static final String DUMMY_ARG_LIST = "dummy";
    private int skipped = 0;
    private Vector namesToDate = new Vector();
    private Hashtable argCount = new Hashtable();
    private String[] noObfNames = null;
    private String[] keywordsToUse;
    private String[] keywordsToExclude;
    private String[] firstLetter;
    private String[] nextLetter;
    private String[] noKeywords = new String[0];
    private String[] someKeywords = new String[]{"a", "if", "do", "for", "int", "new", "try", "byte", "case", "char", "else", "goto", "long", "null", "void"};
    private String[] allKeywords = new String[]{"if", "do", "for", "int", "new", "try", "byte", "case", "char", "else", "goto", "long", "null", "this", "void", "true", "false", "break", "catch", "class", "const", "float", "final", "short", "super", "throw", "while", "double", "import", "native", "public", "return", "static", "switch", "throws", "boolean", "default", "extends", "finally", "package", "private", "abstract", "continue", "volatile", "interface", "protected", "transient", "implements", "instanceof", "synchronized"};
    private static final AtomicBoolean scrambled = new AtomicBoolean(false);
    private static String[] firstLetterLower = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static String[] nextLetterLower = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static String[] firstLetterAll = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static String[] nextLetterAll = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public static void scramble() {
        if (scrambled.compareAndSet(false, true)) {
            firstLetterLower = KeywordNameMaker.scramble(firstLetterLower);
            nextLetterLower = KeywordNameMaker.scramble(nextLetterLower);
            firstLetterAll = KeywordNameMaker.scramble(firstLetterAll);
            nextLetterAll = KeywordNameMaker.scramble(nextLetterAll);
        }
    }

    private static String[] scramble(String ... orderedInput) {
        List<String> list = Arrays.asList(orderedInput);
        Collections.shuffle(list);
        String[] randomOutput = list.toArray(new String[0]);
        return randomOutput;
    }

    public KeywordNameMaker() {
        this(null);
    }

    public KeywordNameMaker(String[] noObfNames) {
        this(noObfNames, true);
    }

    public KeywordNameMaker(String[] noObfNames, boolean useKeywords) {
        this(noObfNames, true, false);
    }

    public KeywordNameMaker(String[] noObfNames, boolean useKeywords, boolean lowerCaseOnly) {
        String[] stringArray = this.noObfNames = noObfNames == null ? new String[]{} : noObfNames;
        if (useKeywords) {
            this.keywordsToUse = this.someKeywords;
            this.keywordsToExclude = this.someKeywords;
        } else {
            this.keywordsToUse = this.noKeywords;
            this.keywordsToExclude = this.allKeywords;
        }
        if (lowerCaseOnly) {
            this.firstLetter = firstLetterLower;
            this.nextLetter = nextLetterLower;
        } else {
            this.firstLetter = firstLetterAll;
            this.nextLetter = nextLetterAll;
        }
    }

    @Override
    public String nextName(String descriptor) {
        String argList = DUMMY_ARG_LIST;
        if (descriptor != null) {
            argList = this.getArgList(descriptor);
        }
        Integer intCount = (Integer)this.argCount.get(argList);
        int theCount = 0;
        if (intCount == null) {
            this.argCount.put(argList, new Integer(theCount));
        } else {
            theCount = intCount + 1;
            this.argCount.remove(argList);
            this.argCount.put(argList, new Integer(theCount));
        }
        return this.getName(theCount);
    }

    private String getArgList(String descriptor) {
        int pos = descriptor.indexOf(41);
        return descriptor.substring(1, pos);
    }

    private String getName(int index) {
        String name = null;
        if (index < this.namesToDate.size()) {
            name = (String)this.namesToDate.elementAt(index);
        } else {
            while (Tools.isInArray(name = this.getNewName(index + this.skipped), this.noObfNames) || index + this.skipped >= this.keywordsToUse.length && Tools.isInArray(name, this.keywordsToExclude)) {
                ++this.skipped;
            }
            this.namesToDate.addElement(name);
        }
        return name;
    }

    private String getNewName(int index) {
        String name = null;
        if (index < this.keywordsToUse.length) {
            name = this.keywordsToUse[index];
        } else if ((index -= this.keywordsToUse.length) < this.firstLetter.length) {
            name = this.firstLetter[index];
        } else {
            index -= this.firstLetter.length;
            int nextLetters = 1;
            int subspaceSize = this.nextLetter.length;
            while (index >= this.firstLetter.length * subspaceSize) {
                index -= this.firstLetter.length * subspaceSize;
                ++nextLetters;
                subspaceSize *= this.nextLetter.length;
            }
            StringBuffer sb = new StringBuffer(this.firstLetter[index / subspaceSize]);
            while (subspaceSize != 1) {
                sb.append(this.nextLetter[(index %= subspaceSize) / (subspaceSize /= this.nextLetter.length)]);
            }
            name = sb.toString();
        }
        return name;
    }
}

