/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.Conversion;
import com.yworks.yguard.obf.Cl;
import com.yworks.yguard.obf.NameMaker;
import com.yworks.yguard.obf.NameMakerFactory;
import com.yworks.yguard.obf.ObfuscationConfig;
import com.yworks.yguard.obf.Pk;
import com.yworks.yguard.obf.PlaceholderCl;
import com.yworks.yguard.obf.TreeItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class PkCl
extends TreeItem {
    protected Hashtable cls = new Hashtable();

    public PkCl(TreeItem parent, String name) {
        super(parent, name);
    }

    public Cl getClass(String name) {
        return (Cl)this.cls.get(name);
    }

    public Enumeration getClassEnum() {
        return this.cls.elements();
    }

    public Enumeration getAllClassEnum() {
        Vector allClasses = new Vector();
        this.addAllClasses(allClasses);
        return allClasses.elements();
    }

    protected void addAllClasses(Vector allClasses) {
        Enumeration enumeration = this.cls.elements();
        while (enumeration.hasMoreElements()) {
            Cl cl = (Cl)enumeration.nextElement();
            allClasses.addElement(cl);
            cl.addAllClasses(allClasses);
        }
    }

    public int getClassCount() {
        return this.cls.size();
    }

    public abstract Cl addClass(Object[] var1);

    public Cl addClass(boolean isInnerClass, Object[] classInfo) {
        String name = (String)classInfo[0];
        String superName = (String)classInfo[1];
        String[] interfaceNames = (String[])classInfo[2];
        int modifiers = (Integer)classInfo[3];
        ObfuscationConfig obfuscationConfig = (ObfuscationConfig)classInfo[4];
        Cl cl = this.getClass(name);
        PlaceholderCl plClassItem = null;
        if (cl instanceof PlaceholderCl) {
            plClassItem = (PlaceholderCl)cl;
            this.cls.remove(name);
            cl = null;
        }
        if (cl == null) {
            cl = new Cl(this, isInnerClass, name, superName, interfaceNames, modifiers, obfuscationConfig);
            this.cls.put(name, cl);
        }
        if (plClassItem != null) {
            Enumeration enumeration = plClassItem.getClassEnum();
            while (enumeration.hasMoreElements()) {
                Cl innerCl = (Cl)enumeration.nextElement();
                innerCl.setParent(cl);
                cl.addClass(innerCl);
            }
        }
        return cl;
    }

    public abstract Cl addPlaceholderClass(String var1);

    public Cl addPlaceholderClass(boolean isInnerClass, String name) {
        Cl cl = this.getClass(name);
        if (cl == null) {
            cl = new PlaceholderCl(this, isInnerClass, name);
            this.cls.put(name, cl);
        }
        return cl;
    }

    public void generateNames() {
        this.generateNames(this.cls);
    }

    protected void generateNames(Hashtable hash) {
        Vector<String> vec = new Vector<String>();
        Enumeration enumeration = hash.elements();
        while (enumeration.hasMoreElements()) {
            TreeItem ti = (TreeItem)enumeration.nextElement();
            if (!ti.isFixed()) continue;
            vec.addElement(ti.getOutName());
        }
        String[] noObfNames = new String[vec.size()];
        for (int i = 0; i < noObfNames.length; ++i) {
            noObfNames[i] = (String)vec.elementAt(i);
        }
        NameMakerFactory nmf = NameMakerFactory.getInstance();
        Enumeration enumeration2 = hash.elements();
        while (enumeration2.hasMoreElements()) {
            TreeItem ti = (TreeItem)enumeration2.nextElement();
            if (ti.isFixed()) continue;
            if (ti instanceof Cl && ((Cl)ti).isInnerClass()) {
                NameMaker innerClassNameMaker = nmf.getInnerClassNameMaker(noObfNames, this.getFullInName());
                ti.setOutName(innerClassNameMaker.nextName(null));
                continue;
            }
            if (ti instanceof Pk) {
                NameMaker packageNameMaker = nmf.getPackageNameMaker(noObfNames, this.getFullInName());
                ti.setOutName(packageNameMaker.nextName(null));
                continue;
            }
            if ("package-info".equals(ti.getInName())) {
                ti.setOutName("package-info");
                continue;
            }
            if ("module-info".equals(ti.getInName())) {
                ti.setOutName("module-info");
                continue;
            }
            NameMaker classNameMaker = nmf.getClassNameMaker(noObfNames, this.getFullInName());
            boolean newNameFound = true;
            Cl.ClassResolver resolver = Cl.getClassResolver();
            do {
                ti.setOutName(classNameMaker.nextName(null));
                String newName = ti.getFullOutName();
                try {
                    resolver.resolve(Conversion.toJavaClass(newName));
                    newNameFound = false;
                }
                catch (ClassNotFoundException cnfe) {
                    newNameFound = true;
                }
            } while (!newNameFound);
        }
    }
}

