/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ClassConstants;
import com.yworks.yguard.obf.classfile.ClassCpInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.DoubleCpInfo;
import com.yworks.yguard.obf.classfile.DynamicCpInfo;
import com.yworks.yguard.obf.classfile.FieldrefCpInfo;
import com.yworks.yguard.obf.classfile.FloatCpInfo;
import com.yworks.yguard.obf.classfile.IntegerCpInfo;
import com.yworks.yguard.obf.classfile.InterfaceMethodrefCpInfo;
import com.yworks.yguard.obf.classfile.InvokeDynamicCpInfo;
import com.yworks.yguard.obf.classfile.LongCpInfo;
import com.yworks.yguard.obf.classfile.MethodHandleCpInfo;
import com.yworks.yguard.obf.classfile.MethodTypeCpInfo;
import com.yworks.yguard.obf.classfile.MethodrefCpInfo;
import com.yworks.yguard.obf.classfile.ModuleCpInfo;
import com.yworks.yguard.obf.classfile.NameAndTypeCpInfo;
import com.yworks.yguard.obf.classfile.PackageCpInfo;
import com.yworks.yguard.obf.classfile.StringCpInfo;
import com.yworks.yguard.obf.classfile.Utf8CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class CpInfo
implements ClassConstants {
    private int u1tag;
    private byte[] info;
    protected int refCount = 0;

    public static CpInfo create(DataInput din) throws IOException {
        if (din == null) {
            throw new NullPointerException("No input stream was provided.");
        }
        CpInfo ci = null;
        switch (din.readUnsignedByte()) {
            case 1: {
                ci = new Utf8CpInfo();
                break;
            }
            case 3: {
                ci = new IntegerCpInfo();
                break;
            }
            case 4: {
                ci = new FloatCpInfo();
                break;
            }
            case 5: {
                ci = new LongCpInfo();
                break;
            }
            case 6: {
                ci = new DoubleCpInfo();
                break;
            }
            case 7: {
                ci = new ClassCpInfo();
                break;
            }
            case 8: {
                ci = new StringCpInfo();
                break;
            }
            case 9: {
                ci = new FieldrefCpInfo();
                break;
            }
            case 10: {
                ci = new MethodrefCpInfo();
                break;
            }
            case 11: {
                ci = new InterfaceMethodrefCpInfo();
                break;
            }
            case 12: {
                ci = new NameAndTypeCpInfo();
                break;
            }
            case 15: {
                ci = new MethodHandleCpInfo();
                break;
            }
            case 16: {
                ci = new MethodTypeCpInfo();
                break;
            }
            case 17: {
                ci = new DynamicCpInfo();
                break;
            }
            case 18: {
                ci = new InvokeDynamicCpInfo();
                break;
            }
            case 19: {
                ci = new ModuleCpInfo();
                break;
            }
            case 20: {
                ci = new PackageCpInfo();
                break;
            }
            default: {
                throw new IOException("Unknown tag type in constant pool.");
            }
        }
        ci.readInfo(din);
        return ci;
    }

    protected CpInfo(int tag) {
        this.u1tag = tag;
    }

    protected abstract void readInfo(DataInput var1) throws IOException;

    protected void markUtf8Refs(ConstantPool pool) {
    }

    protected void markNTRefs(ConstantPool pool) {
    }

    public void write(DataOutput dout) throws IOException {
        if (dout == null) {
            throw new IOException("No output stream was provided.");
        }
        dout.writeByte(this.u1tag);
        this.writeInfo(dout);
    }

    protected abstract void writeInfo(DataOutput var1) throws IOException;

    public int getRefCount() {
        return this.refCount;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        if (this.refCount == 0) {
            throw new IllegalStateException("Illegal to decrement reference count that is already zero.");
        }
        --this.refCount;
    }

    public void resetRefCount() {
        this.refCount = 0;
    }

    public void dump(PrintWriter pw, ClassFile cf, int index) {
        pw.println(this.getClass().getName());
    }
}

