/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExceptionsAttrInfo
extends AttrInfo {
    private int u2numberOfExceptions;
    private int[] u2exceptionIndexTable;

    protected ExceptionsAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "Exceptions";
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2numberOfExceptions = din.readUnsignedShort();
        this.u2exceptionIndexTable = new int[this.u2numberOfExceptions];
        for (int i = 0; i < this.u2numberOfExceptions; ++i) {
            this.u2exceptionIndexTable[i] = din.readUnsignedShort();
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2numberOfExceptions);
        for (int i = 0; i < this.u2numberOfExceptions; ++i) {
            dout.writeShort(this.u2exceptionIndexTable[i]);
        }
    }
}

