/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ModuleExports {
    final int u2exportsIndex;
    final int u2exportsFlags;
    final int[] u2exportsToIndex;

    private ModuleExports(int index, int flags, int[] toIndex) {
        this.u2exportsIndex = index;
        this.u2exportsFlags = flags;
        this.u2exportsToIndex = toIndex;
    }

    int getExportsIndex() {
        return this.u2exportsIndex;
    }

    static ModuleExports read(DataInput din) throws IOException {
        int index = din.readUnsignedShort();
        int flags = din.readUnsignedShort();
        int toCount = din.readUnsignedShort();
        int[] toIndex = new int[toCount];
        for (int j = 0; j < toCount; ++j) {
            toIndex[j] = din.readUnsignedShort();
        }
        return new ModuleExports(index, flags, toIndex);
    }

    void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2exportsIndex);
        dout.writeShort(this.u2exportsFlags);
        int u2exportsToCount = this.u2exportsToIndex.length;
        dout.writeShort(u2exportsToCount);
        for (int i = 0; i < u2exportsToCount; ++i) {
            dout.writeShort(this.u2exportsToIndex[i]);
        }
    }
}

