/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.VerificationTypeInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class StackMapFrameInfo {
    private VerificationTypeInfo[] verificationTypeInfoStack;
    private int u2_offset_delta;
    private VerificationTypeInfo[] verificationTypeInfoLocals;
    private int u1_frameType;

    public static StackMapFrameInfo create(DataInput din) throws IOException {
        if (din == null) {
            throw new NullPointerException("DataInput cannot be null!");
        }
        StackMapFrameInfo smfi = new StackMapFrameInfo();
        smfi.read(din);
        return smfi;
    }

    private StackMapFrameInfo() {
    }

    protected void markUtf8Refs(ConstantPool pool) {
        if (this.u1_frameType >= 64) {
            if (this.u1_frameType >= 64 && this.u1_frameType <= 127) {
                this.verificationTypeInfoStack[0].markUtf8Refs(pool);
            } else if (this.u1_frameType == 247) {
                this.verificationTypeInfoStack[0].markUtf8Refs(pool);
            } else if ((this.u1_frameType < 248 || this.u1_frameType > 250) && this.u1_frameType != 251) {
                if (this.u1_frameType >= 252 && this.u1_frameType <= 254) {
                    for (int i = 0; i < this.verificationTypeInfoStack.length; ++i) {
                        this.verificationTypeInfoStack[i].markUtf8Refs(pool);
                    }
                } else if (this.u1_frameType == 255) {
                    int i;
                    for (i = 0; i < this.verificationTypeInfoLocals.length; ++i) {
                        this.verificationTypeInfoLocals[i].markUtf8Refs(pool);
                    }
                    for (i = 0; i < this.verificationTypeInfoStack.length; ++i) {
                        this.verificationTypeInfoStack[i].markUtf8Refs(pool);
                    }
                } else {
                    throw new IllegalArgumentException("Unknown frame type " + this.u1_frameType);
                }
            }
        }
    }

    public Collection getVerificationTypeInfos() {
        VerificationTypeInfo verificationTypeInfo;
        int i;
        ArrayList<VerificationTypeInfo> result = new ArrayList<VerificationTypeInfo>();
        if (this.verificationTypeInfoLocals != null) {
            for (i = 0; i < this.verificationTypeInfoLocals.length; ++i) {
                verificationTypeInfo = this.verificationTypeInfoLocals[i];
                result.add(verificationTypeInfo);
            }
        }
        if (this.verificationTypeInfoStack != null) {
            for (i = 0; i < this.verificationTypeInfoStack.length; ++i) {
                verificationTypeInfo = this.verificationTypeInfoStack[i];
                result.add(verificationTypeInfo);
            }
        }
        return result;
    }

    private void read(DataInput din) throws IOException {
        this.verificationTypeInfoLocals = null;
        this.verificationTypeInfoStack = null;
        this.u1_frameType = din.readUnsignedByte();
        if (this.u1_frameType >= 64) {
            if (this.u1_frameType >= 64 && this.u1_frameType <= 127) {
                this.verificationTypeInfoStack = new VerificationTypeInfo[1];
                this.verificationTypeInfoStack[0] = VerificationTypeInfo.create(din);
            } else if (this.u1_frameType == 247) {
                this.u2_offset_delta = din.readUnsignedShort();
                this.verificationTypeInfoStack = new VerificationTypeInfo[1];
                this.verificationTypeInfoStack[0] = VerificationTypeInfo.create(din);
            } else if (this.u1_frameType >= 248 && this.u1_frameType <= 250) {
                this.u2_offset_delta = din.readUnsignedShort();
            } else if (this.u1_frameType == 251) {
                this.u2_offset_delta = din.readUnsignedShort();
            } else if (this.u1_frameType >= 252 && this.u1_frameType <= 254) {
                this.u2_offset_delta = din.readUnsignedShort();
                int count = this.u1_frameType - 251;
                this.verificationTypeInfoStack = new VerificationTypeInfo[count];
                for (int i = 0; i < this.verificationTypeInfoStack.length; ++i) {
                    this.verificationTypeInfoStack[i] = VerificationTypeInfo.create(din);
                }
            } else if (this.u1_frameType == 255) {
                int i;
                this.u2_offset_delta = din.readUnsignedShort();
                this.verificationTypeInfoLocals = new VerificationTypeInfo[din.readUnsignedShort()];
                for (i = 0; i < this.verificationTypeInfoLocals.length; ++i) {
                    this.verificationTypeInfoLocals[i] = VerificationTypeInfo.create(din);
                }
                this.verificationTypeInfoStack = new VerificationTypeInfo[din.readUnsignedShort()];
                for (i = 0; i < this.verificationTypeInfoStack.length; ++i) {
                    this.verificationTypeInfoStack[i] = VerificationTypeInfo.create(din);
                }
            } else {
                throw new IllegalArgumentException("Unknown frame type " + this.u1_frameType);
            }
        }
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeByte(this.u1_frameType);
        if (this.u1_frameType >= 64) {
            if (this.u1_frameType >= 64 && this.u1_frameType <= 127) {
                this.verificationTypeInfoStack[0].write(dout);
            } else if (this.u1_frameType == 247) {
                dout.writeShort(this.u2_offset_delta);
                this.verificationTypeInfoStack[0].write(dout);
            } else if (this.u1_frameType >= 248 && this.u1_frameType <= 250) {
                dout.writeShort(this.u2_offset_delta);
            } else if (this.u1_frameType == 251) {
                dout.writeShort(this.u2_offset_delta);
            } else if (this.u1_frameType >= 252 && this.u1_frameType <= 254) {
                dout.writeShort(this.u2_offset_delta);
                for (int i = 0; i < this.verificationTypeInfoStack.length; ++i) {
                    this.verificationTypeInfoStack[i].write(dout);
                }
            } else if (this.u1_frameType == 255) {
                int i;
                dout.writeShort(this.u2_offset_delta);
                dout.writeShort(this.verificationTypeInfoLocals.length);
                for (i = 0; i < this.verificationTypeInfoLocals.length; ++i) {
                    this.verificationTypeInfoLocals[i].write(dout);
                }
                dout.writeShort(this.verificationTypeInfoStack.length);
                for (i = 0; i < this.verificationTypeInfoStack.length; ++i) {
                    this.verificationTypeInfoStack[i].write(dout);
                }
            } else {
                throw new IllegalArgumentException("Unknown frame type " + this.u1_frameType);
            }
        }
    }
}

