/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.bson.Bson;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BsonRegularExpression
implements Bson {
    private static final long serialVersionUID = 1L;
    private static final String REGEX = "$regex";
    private static final String OPTIONS = "$options";
    private final String pattern;
    private final String options;
    private final transient AtomicReference<Pattern> compiledPattern = new AtomicReference<Object>(null);

    public BsonRegularExpression(String pattern, String options) {
        this.pattern = pattern;
        this.options = options;
    }

    public BsonRegularExpression(String pattern) {
        this(pattern, null);
    }

    public Document toDocument() {
        Document document = new Document(REGEX, this.pattern);
        if (this.options != null) {
            document.append(OPTIONS, this.options);
        }
        return document;
    }

    private static BsonRegularExpression fromDocument(Document queryObject) {
        String options = "";
        if (queryObject.containsKey(OPTIONS)) {
            options = queryObject.get(OPTIONS).toString();
        }
        String pattern = queryObject.get(REGEX).toString();
        return new BsonRegularExpression(pattern, options);
    }

    public static boolean isRegularExpression(Object object) {
        if (object instanceof Document) {
            return ((Document)object).containsKey(REGEX);
        }
        return object instanceof BsonRegularExpression;
    }

    public static BsonRegularExpression convertToRegularExpression(Object pattern) {
        Assert.isTrue(BsonRegularExpression.isRegularExpression(pattern), () -> "'" + String.valueOf(pattern) + "' is not a regular expression");
        if (pattern instanceof BsonRegularExpression) {
            return (BsonRegularExpression)pattern;
        }
        return BsonRegularExpression.fromDocument((Document)pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getOptions() {
        return this.options;
    }

    private Pattern toPattern() {
        Pattern pattern = this.compiledPattern.get();
        if (pattern == null) {
            pattern = this.createPattern();
            this.compiledPattern.lazySet(pattern);
        }
        return pattern;
    }

    Pattern createPattern() {
        int flags = 0;
        block7: for (char flag : this.options.toCharArray()) {
            switch (flag) {
                case 'i': {
                    flags |= 2;
                    continue block7;
                }
                case 'm': {
                    flags |= 8;
                    continue block7;
                }
                case 'x': {
                    flags |= 4;
                    continue block7;
                }
                case 's': {
                    flags |= 0x20;
                    continue block7;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("unknown pattern flag: '" + flag + "'");
                }
            }
        }
        return Pattern.compile(this.pattern, flags |= 0x40);
    }

    public String toString() {
        Document representative = new Document(REGEX, this.pattern);
        if (this.options != null) {
            representative.put(OPTIONS, (Object)this.options);
        }
        return Json.toJsonValue(representative);
    }

    public Matcher matcher(String string) {
        return this.toPattern().matcher(string);
    }
}

