/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class TopicInformation {
    private static final Pattern VERSION_SEG = Pattern.compile("[0-9]+");
    private final String service;
    private final String version;
    private final String type;
    private final List<String> resources;
    private final String action;
    private final Optional<Status> status;

    public TopicInformation(String service, String version, String type, List<String> resources, String action, Optional<Status> status) {
        this.service = service;
        this.version = version;
        this.type = type;
        this.resources = resources;
        this.action = action;
        this.status = status;
    }

    public String getService() {
        return this.service;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getAction() {
        return this.action;
    }

    public Optional<Status> getStatus() {
        return this.status;
    }

    public static TopicInformation fromString(String topic) {
        Optional<Status> status;
        Objects.requireNonNull(topic);
        LinkedList<String> toks = new LinkedList<String>(Arrays.asList(topic.split("\\.")));
        String service = toks.pollFirst();
        LinkedList<String> version = new LinkedList<String>();
        while (TopicInformation.isVersionSegment(toks.peekFirst())) {
            version.add(toks.pollFirst());
        }
        String type = toks.pollFirst();
        if ("event".equals(type) && toks.size() > 2) {
            String last = toks.peekLast();
            Status statusValue = null;
            try {
                statusValue = Status.valueOf(last.toUpperCase());
                toks.pollLast();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            status = Optional.ofNullable(statusValue);
        } else {
            status = Optional.empty();
        }
        String action = toks.pollLast();
        LinkedList<String> resources = toks;
        if (service == null || service.isEmpty()) {
            throw new IllegalArgumentException("Wrong topic syntax");
        }
        if (version.isEmpty()) {
            throw new IllegalArgumentException("Wrong topic syntax");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Wrong topic syntax");
        }
        if (resources.isEmpty()) {
            throw new IllegalArgumentException("Wrong topic syntax");
        }
        return new TopicInformation(service, String.join((CharSequence)".", version), type, resources, action, status);
    }

    private static boolean isVersionSegment(String string) {
        if (string == null) {
            return false;
        }
        return VERSION_SEG.matcher(string).matches();
    }

    public static enum Status {
        QUEUED,
        SUCCEED,
        FAILED,
        DONE;

    }
}

