/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java.jms;

import de.dentrassi.asyncapi.AsyncApi;
import de.dentrassi.asyncapi.MessageReference;
import de.dentrassi.asyncapi.Topic;
import de.dentrassi.asyncapi.generator.java.ConnectorType;
import de.dentrassi.asyncapi.generator.java.Generator;
import de.dentrassi.asyncapi.generator.java.GeneratorExtension;
import de.dentrassi.asyncapi.generator.java.TypeBuilder;
import de.dentrassi.asyncapi.generator.java.TypeInformation;
import de.dentrassi.asyncapi.generator.java.util.JDTHelper;
import de.dentrassi.asyncapi.generator.java.util.Java;
import de.dentrassi.asyncapi.generator.java.util.Names;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class JmsGeneratorExtension
implements GeneratorExtension {
    private static final String TYPE_NAME_ABSTRACT_JMS_CONNECTOR = "de.dentrassi.asyncapi.jms.AbstractJmsConnector";

    @Override
    public void generate(AsyncApi api, Generator.Options options, Generator.Context context) {
        this.createConnector(context, ConnectorType.CLIENT);
        this.createConnector(context, ConnectorType.SERVER);
        this.createServiceClasses(context, ConnectorType.CLIENT);
        this.createServiceClasses(context, ConnectorType.SERVER);
    }

    private void createConnector(Generator.Context context, ConnectorType connectorType) {
        TypeBuilder builder = context.createTypeBuilder("jms." + connectorType.getPackageName());
        Consumer<TypeDeclaration> typeCustomizer = TypeBuilder.superClass(TYPE_NAME_ABSTRACT_JMS_CONNECTOR).andThen(TypeBuilder.superInterfaces(Arrays.asList(context.fullQualifiedName(connectorType.getSimpleTypeName()))));
        builder.createType(new TypeInformation("Jms" + connectorType.getSimpleTypeName(), null, null), typeCustomizer, b -> {
            this.createBuilderType((TypeBuilder)b, connectorType);
            this.createNewBuilderMethod((TypeBuilder)b);
            this.createServiceFields((TypeBuilder)b, context, connectorType);
            this.createConstructor((TypeBuilder)b, context, connectorType);
            this.createVersions((TypeBuilder)b, context, connectorType);
        });
    }

    private void createServiceClasses(Generator.Context context, ConnectorType connectorType) {
        for (Map.Entry<String, Map<String, List<Topic>>> entry : context.getServiceDefinitions().getVersions().entrySet()) {
            String version = Names.makeVersion(entry.getKey());
            for (Map.Entry<String, List<Topic>> serviceEntry : entry.getValue().entrySet()) {
                String serviceName = Names.toCamelCase(serviceEntry.getKey(), false);
                String serviceTypeName = this.makeServiceType(context, connectorType, version, serviceEntry, false);
                String implName = Names.toCamelCase(serviceName, true) + "Impl";
                TypeBuilder builder = context.createTypeBuilder("jms." + connectorType.getPackageName() + "." + version);
                Consumer<TypeDeclaration> typeCustomizer = TypeBuilder.superInterfaces(Arrays.asList(serviceTypeName)).andThen(TypeBuilder.superClass("de.dentrassi.asyncapi.jms.AbstractJmsServiceImpl"));
                builder.createType(new TypeInformation(implName, null, null), typeCustomizer, b -> {
                    this.createServiceConstructor((TypeBuilder)b, implName);
                    for (Topic topic : (List)serviceEntry.getValue()) {
                        String name = Generator.makeTopicMethodName(context.getServiceDefinitions().getTopics().get(topic));
                        b.createMethod((ast, cu) -> {
                            MethodDeclaration md = ast.newMethodDeclaration();
                            JDTHelper.makePublic((BodyDeclaration)md);
                            JDTHelper.addSimpleAnnotation((BodyDeclaration)md, "Override");
                            md.setName(ast.newSimpleName(name));
                            md.setReturnType2((Type)Generator.evalEventMethodType(ast, topic, context, connectorType));
                            Block body = ast.newBlock();
                            md.setBody(body);
                            ReturnStatement ret = ast.newReturnStatement();
                            MessageReference pubMsg = connectorType.getPublish(topic);
                            MessageReference subMsg = connectorType.getSubscribe(topic);
                            if (pubMsg != null && subMsg != null) {
                                ret.setExpression(this.aggregate((AST)ast, this.publisher((AST)ast, topic.getName()), this.subscriber((AST)ast, topic.getName(), Generator.messageTypeName(subMsg, context))));
                            } else if (pubMsg != null) {
                                ret.setExpression(this.publisher((AST)ast, topic.getName()));
                            } else if (subMsg != null) {
                                ret.setExpression(this.subscriber((AST)ast, topic.getName(), Generator.messageTypeName(subMsg, context)));
                            }
                            body.statements().add(ret);
                            return md;
                        });
                    }
                });
            }
        }
    }

    private Expression aggregate(AST ast, Expression publisher, Expression subscriber) {
        SimpleType type = ast.newSimpleType(ast.newName("de.dentrassi.asyncapi.util.AggregatePublishSubscriber"));
        ParameterizedType pt = ast.newParameterizedType((Type)type);
        ClassInstanceCreation cic = ast.newClassInstanceCreation();
        cic.setType((Type)pt);
        cic.arguments().add(publisher);
        cic.arguments().add(subscriber);
        return cic;
    }

    private Expression subscriber(AST ast, String topicName, String messageTypeName) {
        MethodInvocation mi = ast.newMethodInvocation();
        mi.setName(ast.newSimpleName("createSubscriber"));
        mi.arguments().add(JDTHelper.newStringLiteral(ast, topicName));
        TypeLiteral tl = ast.newTypeLiteral();
        tl.setType((Type)ast.newSimpleType(ast.newName(messageTypeName)));
        mi.arguments().add(tl);
        tl = ast.newTypeLiteral();
        tl.setType((Type)ast.newSimpleType(ast.newName(messageTypeName + ".Payload")));
        mi.arguments().add(tl);
        return mi;
    }

    private Expression publisher(AST ast, String topicName) {
        MethodInvocation mi = ast.newMethodInvocation();
        mi.setName(ast.newSimpleName("createPublisher"));
        mi.arguments().add(JDTHelper.newStringLiteral(ast, topicName));
        return mi;
    }

    private void createServiceConstructor(TypeBuilder b, String implName) {
        b.createMethod((ast, cu) -> {
            MethodDeclaration md = ast.newMethodDeclaration();
            md.setConstructor(true);
            md.setName(ast.newSimpleName(implName));
            JDTHelper.makePublic((BodyDeclaration)md);
            md.parameters().add(JDTHelper.createParameter(ast, "javax.jms.Connection", "connection", Modifier.ModifierKeyword.FINAL_KEYWORD));
            md.parameters().add(JDTHelper.createParameter(ast, "java.util.concurrent.Executor", "executor", Modifier.ModifierKeyword.FINAL_KEYWORD));
            md.parameters().add(JDTHelper.createParameter(ast, "de.dentrassi.asyncapi.jms.JmsPayloadFormat", "payloadFormat", Modifier.ModifierKeyword.FINAL_KEYWORD));
            md.parameters().add(JDTHelper.createParameter(ast, "String", "baseTopic", Modifier.ModifierKeyword.FINAL_KEYWORD));
            Block body = ast.newBlock();
            md.setBody(body);
            SuperConstructorInvocation sci = ast.newSuperConstructorInvocation();
            body.statements().add(sci);
            sci.arguments().add(ast.newSimpleName("connection"));
            sci.arguments().add(ast.newSimpleName("executor"));
            sci.arguments().add(ast.newSimpleName("payloadFormat"));
            sci.arguments().add(ast.newSimpleName("baseTopic"));
            return md;
        });
    }

    private void createVersions(TypeBuilder builder, Generator.Context context, ConnectorType connectorType) {
        for (Map.Entry<String, Map<String, List<Topic>>> entry : context.getServiceDefinitions().getVersions().entrySet()) {
            String version = Names.makeVersion(entry.getKey());
            String versionTypeName = version.toUpperCase();
            builder.createMethod((ast, cu) -> {
                MethodDeclaration md = ast.newMethodDeclaration();
                md.setName(ast.newSimpleName(version));
                md.setReturnType2((Type)ast.newSimpleType(ast.newName(versionTypeName)));
                JDTHelper.addSimpleAnnotation((BodyDeclaration)md, "Override");
                JDTHelper.makePublic((BodyDeclaration)md);
                Block body = ast.newBlock();
                md.setBody(body);
                ReturnStatement ret = ast.newReturnStatement();
                body.statements().add(ret);
                AnonymousClassDeclaration cd = ast.newAnonymousClassDeclaration();
                ClassInstanceCreation ci = ast.newClassInstanceCreation();
                ci.setAnonymousClassDeclaration(cd);
                ci.setType((Type)ast.newSimpleType(ast.newName(versionTypeName)));
                ret.setExpression((Expression)ci);
                for (Map.Entry<String, List<Topic>> entry2 : ((Map)entry.getValue()).entrySet()) {
                    String serviceName = Names.toCamelCase((String)entry2.getKey(), false);
                    String serviceInstanceField = version + Names.toCamelCase(serviceName, true);
                    String serviceTypeName = this.makeServiceType(context, connectorType, version, entry2, false);
                    MethodDeclaration smd = ast.newMethodDeclaration();
                    smd.setName(ast.newSimpleName(serviceName));
                    smd.setReturnType2((Type)ast.newSimpleType(ast.newName(serviceTypeName)));
                    JDTHelper.addSimpleAnnotation((BodyDeclaration)smd, "Override");
                    JDTHelper.makePublic((BodyDeclaration)smd);
                    cd.bodyDeclarations().add(smd);
                    Block sbody = ast.newBlock();
                    smd.setBody(sbody);
                    ReturnStatement ret2 = ast.newReturnStatement();
                    sbody.statements().add(ret2);
                    ThisExpression te = ast.newThisExpression();
                    te.setQualifier((Name)ast.newSimpleName("Jms" + connectorType.getSimpleTypeName()));
                    FieldAccess fa = ast.newFieldAccess();
                    fa.setExpression((Expression)te);
                    fa.setName(ast.newSimpleName(serviceInstanceField));
                    ret2.setExpression((Expression)fa);
                }
                return md;
            });
        }
    }

    private void createBuilderType(TypeBuilder builder, ConnectorType connectorType) {
        Consumer<TypeDeclaration> typeCustomizer = TypeBuilder.make(Modifier.ModifierKeyword.STATIC_KEYWORD).andThen(td -> {
            AST ast = td.getAST();
            SimpleType type = ast.newSimpleType(ast.newName("de.dentrassi.asyncapi.jms.AbstractJmsConnector.Builder"));
            ParameterizedType pt = ast.newParameterizedType((Type)type);
            pt.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName("Jms" + connectorType.getSimpleTypeName())));
            td.setSuperclassType((Type)pt);
        });
        builder.createType(new TypeInformation("Builder", null, null), typeCustomizer, b -> b.createMethod((ast, cu) -> {
            MethodDeclaration md = ast.newMethodDeclaration();
            JDTHelper.addSimpleAnnotation((BodyDeclaration)md, "Override");
            JDTHelper.makePublic((BodyDeclaration)md);
            md.setName(ast.newSimpleName("build"));
            md.setReturnType2((Type)ast.newSimpleType(ast.newName("Jms" + connectorType.getSimpleTypeName())));
            TryStatement ts = ast.newTryStatement();
            Block tryBlock = ast.newBlock();
            ts.setBody(tryBlock);
            ReturnStatement ret = ast.newReturnStatement();
            ClassInstanceCreation cir = ast.newClassInstanceCreation();
            cir.setType((Type)ast.newSimpleType(ast.newName("Jms" + connectorType.getSimpleTypeName())));
            cir.arguments().add(ast.newThisExpression());
            ret.setExpression((Expression)cir);
            tryBlock.statements().add(ret);
            Block catchBlock = ast.newBlock();
            ThrowStatement trs = ast.newThrowStatement();
            ClassInstanceCreation cir2 = ast.newClassInstanceCreation();
            cir2.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("RuntimeException")));
            cir2.arguments().add(ast.newSimpleName("e"));
            trs.setExpression((Expression)cir2);
            catchBlock.statements().add(trs);
            ts.catchClauses().add(JDTHelper.createCatchBlock(ast, "Exception", catchBlock));
            Block body = ast.newBlock();
            body.statements().add(ts);
            md.setBody(body);
            return md;
        }));
    }

    private void createNewBuilderMethod(TypeBuilder builder) {
        builder.createBodyContent((ast, cu) -> Java.parseSingleList(ast, 4, "/** Create new builder */ public static Builder newBuilder() {return new Builder();}", Java::firstBodyDeclaration));
    }

    private void createServiceFields(TypeBuilder builder, Generator.Context context, ConnectorType connectorType) {
        for (Map.Entry<String, Map<String, List<Topic>>> entry : context.getServiceDefinitions().getVersions().entrySet()) {
            String version = Names.makeVersion(entry.getKey());
            for (Map.Entry<String, List<Topic>> serviceEntry : entry.getValue().entrySet()) {
                String serviceName = Names.toCamelCase(serviceEntry.getKey(), false);
                String serviceInstanceField = version + Names.toCamelCase(serviceName, true);
                String serviceTypeName = this.makeServiceType(context, connectorType, version, serviceEntry, true);
                builder.createBodyContent((ast, cu) -> {
                    VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
                    vdf.setName(ast.newSimpleName(serviceInstanceField));
                    FieldDeclaration fd = ast.newFieldDeclaration(vdf);
                    fd.setType((Type)ast.newSimpleType(ast.newName(serviceTypeName)));
                    JDTHelper.make((BodyDeclaration)fd, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
                    return Collections.singletonList(fd);
                });
            }
        }
    }

    private void createConstructor(TypeBuilder builder, Generator.Context context, ConnectorType connectorType) {
        builder.createMethod((ast, cu) -> {
            MethodDeclaration md = ast.newMethodDeclaration();
            md.setConstructor(true);
            md.setName(ast.newSimpleName("Jms" + connectorType.getSimpleTypeName()));
            JDTHelper.makePrivate((BodyDeclaration)md);
            md.parameters().add(JDTHelper.createParameter(ast, "Builder", "builder", Modifier.ModifierKeyword.FINAL_KEYWORD));
            Block body = ast.newBlock();
            md.setBody(body);
            SuperConstructorInvocation s = ast.newSuperConstructorInvocation();
            body.statements().add(s);
            s.arguments().add(ast.newSimpleName("builder"));
            md.thrownExceptionTypes().add(ast.newSimpleType(ast.newName("javax.jms.JMSException")));
            for (Map.Entry<String, Map<String, List<Topic>>> entry : context.getServiceDefinitions().getVersions().entrySet()) {
                String version = Names.makeVersion(entry.getKey());
                for (Map.Entry<String, List<Topic>> serviceEntry : entry.getValue().entrySet()) {
                    String serviceName = Names.toCamelCase(serviceEntry.getKey(), false);
                    String serviceInstanceField = version + Names.toCamelCase(serviceName, true);
                    String serviceTypeName = this.makeServiceType(context, connectorType, version, serviceEntry, true);
                    this.createServiceInstance(md, serviceInstanceField, serviceTypeName);
                }
            }
            return md;
        });
    }

    private String makeServiceType(Generator.Context context, ConnectorType connectorType, String version, Map.Entry<String, List<Topic>> serviceEntry, boolean implementation) {
        if (implementation) {
            return context.fullQualifiedName("jms", connectorType.getPackageName(), version) + "." + Names.toCamelCase(serviceEntry.getKey() + "Impl", true);
        }
        return context.fullQualifiedName(connectorType.getPackageName(), version) + "." + Names.toCamelCase(serviceEntry.getKey(), true);
    }

    private void createServiceInstance(MethodDeclaration md, String serviceInstanceField, String serviceTypeName) {
        AST ast = md.getAST();
        Block body = md.getBody();
        Assignment as = ast.newAssignment();
        FieldAccess fa = ast.newFieldAccess();
        fa.setName(ast.newSimpleName(serviceInstanceField));
        fa.setExpression((Expression)ast.newThisExpression());
        as.setLeftHandSide((Expression)fa);
        ClassInstanceCreation cic = ast.newClassInstanceCreation();
        cic.setType((Type)ast.newSimpleType(ast.newName(serviceTypeName)));
        FieldAccess t = ast.newFieldAccess();
        t.setExpression((Expression)ast.newThisExpression());
        t.setName(ast.newSimpleName("connection"));
        cic.arguments().add(t);
        t = ast.newFieldAccess();
        t.setExpression((Expression)ast.newThisExpression());
        t.setName(ast.newSimpleName("executor"));
        cic.arguments().add(t);
        MethodInvocation mi = ast.newMethodInvocation();
        mi.setExpression((Expression)ast.newSimpleName("builder"));
        mi.setName(ast.newSimpleName("payloadFormat"));
        cic.arguments().add(mi);
        mi = ast.newMethodInvocation();
        mi.setExpression((Expression)ast.newSimpleName("builder"));
        mi.setName(ast.newSimpleName("baseTopic"));
        cic.arguments().add(mi);
        as.setRightHandSide((Expression)cic);
        body.statements().add(ast.newExpressionStatement((Expression)as));
    }
}

