/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java.util;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public final class JDTHelper {
    private JDTHelper() {
    }

    public static TextElement newText(AST ast, String text) {
        TextElement result = ast.newTextElement();
        result.setText(text);
        return result;
    }

    public static StringLiteral newStringLiteral(AST ast, String value) {
        StringLiteral result = ast.newStringLiteral();
        result.setLiteralValue(value);
        return result;
    }

    public static void make(AST ast, List<? super Object> decl, Modifier.ModifierKeyword ... keywords) {
        for (Modifier.ModifierKeyword keyword : keywords) {
            decl.add(ast.newModifier(keyword));
        }
    }

    public static void make(BodyDeclaration decl, Modifier.ModifierKeyword ... keywords) {
        JDTHelper.make(decl.getAST(), decl.modifiers(), keywords);
    }

    public static void make(SingleVariableDeclaration decl, Modifier.ModifierKeyword ... keywords) {
        JDTHelper.make(decl.getAST(), decl.modifiers(), keywords);
    }

    public static void makeStatic(BodyDeclaration decl) {
        JDTHelper.make(decl, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public static void makeAbstract(BodyDeclaration decl) {
        JDTHelper.make(decl, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
    }

    public static void makePublic(BodyDeclaration decl) {
        JDTHelper.make(decl, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public static void makeProtected(BodyDeclaration decl) {
        JDTHelper.make(decl, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public static void makePrivate(BodyDeclaration decl) {
        JDTHelper.make(decl, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public static SingleVariableDeclaration createParameter(AST ast, String typeName, String name, Modifier.ModifierKeyword ... keywords) {
        SingleVariableDeclaration arg = ast.newSingleVariableDeclaration();
        arg.setName(ast.newSimpleName(name));
        arg.setType((Type)ast.newSimpleType(ast.newName(typeName)));
        JDTHelper.make(arg, keywords);
        return arg;
    }

    public static FieldDeclaration createField(AST ast, String typeName, String name, Modifier.ModifierKeyword ... keywords) {
        return JDTHelper.createField(ast, (Type)ast.newSimpleType(ast.newName(typeName)), name, null, keywords);
    }

    public static FieldDeclaration createField(AST ast, Type type, String name, Expression initializer, Modifier.ModifierKeyword ... keywords) {
        VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
        vdf.setName(ast.newSimpleName(name));
        if (initializer != null) {
            vdf.setInitializer(initializer);
        }
        FieldDeclaration fd = ast.newFieldDeclaration(vdf);
        JDTHelper.make((BodyDeclaration)fd, keywords);
        fd.setType(type);
        return fd;
    }

    public static void addSimpleAnnotation(BodyDeclaration decl, String name) {
        AST ast = decl.getAST();
        MarkerAnnotation ann = ast.newMarkerAnnotation();
        ann.setTypeName(ast.newName(name));
        decl.modifiers().add(ann);
    }

    public static CatchClause createCatchBlock(AST ast, String typeName, Block catchBlock) {
        CatchClause cc = ast.newCatchClause();
        cc.setException(JDTHelper.createParameter(ast, typeName, "e", Modifier.ModifierKeyword.FINAL_KEYWORD));
        cc.setBody(catchBlock);
        return cc;
    }
}

