/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java.util;

import java.util.Arrays;
import java.util.stream.Collectors;

public class Version
implements Comparable<Version> {
    private final int[] version;

    private Version(int[] version) {
        this.version = version;
    }

    public String toString() {
        return Arrays.stream(this.version).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }

    @Override
    public int compareTo(Version other) {
        int max = Math.max(this.version.length, other.version.length);
        for (int i = 0; i < max; ++i) {
            int v2;
            int v1 = i < this.version.length ? this.version[i] : 0;
            int rc = Integer.compare(v1, v2 = i < other.version.length ? other.version[i] : 0);
            if (rc == 0) continue;
            return rc;
        }
        return 0;
    }

    public static Version valueOf(String version) {
        if (version == null) {
            return null;
        }
        String[] toks = version.split("\\.");
        int[] v = new int[toks.length];
        for (int i = 0; i < toks.length; ++i) {
            v[i] = Integer.parseInt(toks[i]);
        }
        return new Version(v);
    }
}

