/*
 * Copyright (C) 2017 Jens Reimann <jreimann@redhat.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.dentrassi.asyncapi;

public class ArrayType extends Type {

    private final TypeReference itemType;
    private final boolean unique;

    public ArrayType(final String name, final TypeReference itemType, final boolean unique) {
        super("", name);
        this.itemType = itemType;
        this.unique = unique;
    }

    public TypeReference getItemType() {
        return this.itemType;
    }

    public boolean isUnique() {
        return this.unique;
    }
}