/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.ScriptExec;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;

public class Launcher {
    private static final String LONG_CLASSPATH_JAR_PREFIX = "long-classpath";
    private static final String MATCH_CHUNKS_OF_70_CHARACTERS = "(?<=\\G.{70})";

    public static int launchJavaBlocking(boolean blocking, List<File> cp, List<String> vmArgs, String mainClass, @Nullable Consumer<Process> monitorProcess, String ... args) throws IOException, InterruptedException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        Object javaCmd = new File(javaBin).exists() ? javaBin : "java";
        File classpathJar = Launcher.toJarWithClasspath(cp);
        classpathJar.deleteOnExit();
        ArrayList<String> command = new ArrayList<String>();
        command.add((String)javaCmd);
        command.addAll(vmArgs);
        command.add("-classpath");
        command.add(classpathJar.getAbsolutePath());
        command.add(mainClass);
        command.addAll(Arrays.asList(args));
        if (blocking) {
            return Launcher.launchAndInheritIO(null, command, monitorProcess);
        }
        ScriptExec.script(ScriptExec.quoteAll(command)).execSeparate(monitorProcess);
        return 0;
    }

    public static int launchAndInheritIO(File cwd, List<String> args) throws IOException, InterruptedException {
        return Launcher.launchAndInheritIO(cwd, args, null);
    }

    public static int launchAndInheritIO(File cwd, List<String> args, @Nullable Consumer<Process> monitorProcess) throws IOException, InterruptedException {
        return Launcher.launchAndInheritIO(cwd, args, Map.of(), monitorProcess);
    }

    public static int launchAndInheritIO(File cwd, List<String> args, Map<String, String> env, @Nullable Consumer<Process> monitorProcess) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.environment().putAll(env);
        if (cwd != null) {
            builder.directory(cwd);
        }
        Process process = builder.start();
        StreamPumper outPumper = new StreamPumper(process, process.getInputStream(), System.out);
        StreamPumper errPumper = new StreamPumper(process, process.getErrorStream(), System.err);
        if (monitorProcess != null) {
            new Thread(() -> monitorProcess.accept(process)).start();
        }
        int exitCode = process.waitFor();
        process.getOutputStream().flush();
        outPumper.join();
        errPumper.join();
        return exitCode;
    }

    private static File toJarWithClasspath(List<File> files) throws IOException {
        File jarFile = File.createTempFile(LONG_CLASSPATH_JAR_PREFIX, ".jar");
        try (ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));){
            zip.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            try (PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)zip, StandardCharsets.UTF_8)));){
                pw.println("Manifest-Version: 1.0");
                StringBuilder bufferClassPath = new StringBuilder("Class-Path: ");
                for (File file : files) {
                    if (bufferClassPath.length() != 0) {
                        bufferClassPath.append(' ');
                    }
                    bufferClassPath.append(file.toURI());
                }
                pw.println(String.join((CharSequence)"\n ", bufferClassPath.toString().split(MATCH_CHUNKS_OF_70_CHARACTERS)));
            }
        }
        return jarFile;
    }

    public static ArrayList<File> copyAndSortClasspath(Iterable<File> files) {
        ArrayList<File> copy = new ArrayList<File>();
        ArrayList<File> addToEnd = new ArrayList<File>();
        for (File f : files) {
            if (f.getName().startsWith("slf4j-nop")) continue;
            if (f.getName().startsWith("org.apache.jasper.glassfish") || f.getName().startsWith("biz.aQute.bndlib")) {
                addToEnd.add(f);
                continue;
            }
            copy.add(f);
        }
        copy.sort(Comparator.comparing(File::getName).reversed());
        copy.addAll(addToEnd);
        return copy;
    }

    static class StreamPumper
    extends Thread {
        private final Process process;
        private final InputStream in;
        private final PrintStream out;

        private StreamPumper(Process process, InputStream in, PrintStream out) {
            this.process = process;
            this.in = in;
            this.out = out;
            this.start();
        }

        @Override
        public void run() {
            block3: {
                byte[] buf = new byte[1024];
                try {
                    int numRead;
                    while ((numRead = this.in.read(buf)) != -1) {
                        this.out.write(buf, 0, numRead);
                        this.out.flush();
                    }
                }
                catch (IOException e) {
                    if (!this.process.isAlive()) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

