/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.info;

import java.nio.charset.StandardCharsets;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.smb2.RequestWithFileId;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.Smb2Constants;
import jcifs.internal.smb2.info.Smb2QueryDirectoryResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2QueryDirectoryRequest
extends ServerMessageBlock2Request<Smb2QueryDirectoryResponse>
implements RequestWithFileId {
    public static final byte FILE_DIRECTORY_INFO = 1;
    public static final byte FILE_FULL_DIRECTORY_INFO = 2;
    public static final byte FILE_BOTH_DIRECTORY_INFO = 3;
    public static final byte FILE_NAMES_INFO = 12;
    public static final byte FILE_ID_BOTH_DIRECTORY_INFO = 36;
    public static final byte FILE_ID_FULL_DIRECTORY_INFO = 38;
    public static final byte SMB2_RESTART_SCANS = 1;
    public static final byte SMB2_RETURN_SINGLE_ENTRY = 2;
    public static final byte SMB2_INDEX_SPECIFIED = 4;
    public static final byte SMB2_REOPEN = 16;
    private byte fileInformationClass = (byte)3;
    private byte queryFlags;
    private int fileIndex;
    private byte[] fileId;
    private int outputBufferLength;
    private String fileName;

    public Smb2QueryDirectoryRequest(Configuration config) {
        this(config, Smb2Constants.UNSPECIFIED_FILEID);
    }

    public Smb2QueryDirectoryRequest(Configuration config, byte[] fileId) {
        super(config, 14);
        this.outputBufferLength = config.getMaximumBufferSize() - 72 & 0xFFFFFFF8;
        this.fileId = fileId;
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    public void setFileInformationClass(byte fileInformationClass) {
        this.fileInformationClass = fileInformationClass;
    }

    public void setQueryFlags(byte queryFlags) {
        this.queryFlags = queryFlags;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    protected Smb2QueryDirectoryResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2QueryDirectoryResponse> req) {
        return new Smb2QueryDirectoryResponse(tc.getConfig(), this.fileInformationClass);
    }

    @Override
    public int size() {
        return Smb2QueryDirectoryRequest.size8(96 + (this.fileName != null ? 2 * this.fileName.length() : 0));
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(33L, dst, dstIndex);
        dst[dstIndex + 2] = this.fileInformationClass;
        dst[dstIndex + 3] = this.queryFlags;
        SMBUtil.writeInt4(this.fileIndex, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        int fnOffsetOffset = dstIndex += 16;
        int fnLengthOffset = dstIndex + 2;
        SMBUtil.writeInt4(this.outputBufferLength, dst, dstIndex += 4);
        dstIndex += 4;
        if (this.fileName == null) {
            SMBUtil.writeInt2(0L, dst, fnOffsetOffset);
            SMBUtil.writeInt2(0L, dst, fnLengthOffset);
        } else {
            byte[] fnBytes = this.fileName.getBytes(StandardCharsets.UTF_16LE);
            SMBUtil.writeInt2(dstIndex - this.getHeaderStart(), dst, fnOffsetOffset);
            SMBUtil.writeInt2(fnBytes.length, dst, fnLengthOffset);
            System.arraycopy(fnBytes, 0, dst, dstIndex, fnBytes.length);
            dstIndex += fnBytes.length;
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

