/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.CloseableIterator;
import jcifs.Configuration;
import jcifs.ResourceFilter;
import jcifs.ResourceNameFilter;
import jcifs.SID;
import jcifs.SmbConstants;
import jcifs.SmbResource;
import jcifs.SmbResourceLocator;
import jcifs.SmbTreeHandle;
import jcifs.SmbWatchHandle;
import jcifs.context.SingletonContext;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.msrpc.MsrpcShareGetInfo;
import jcifs.internal.AllocInfo;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.CommonServerMessageBlockResponse;
import jcifs.internal.SmbBasicFileInfo;
import jcifs.internal.dtyp.ACE;
import jcifs.internal.dtyp.SecurityDescriptor;
import jcifs.internal.fscc.BasicFileInformation;
import jcifs.internal.fscc.FileBasicInfo;
import jcifs.internal.fscc.FileInternalInfo;
import jcifs.internal.fscc.FileRenameInformation2;
import jcifs.internal.fscc.FileStandardInfo;
import jcifs.internal.fscc.FileSystemInformation;
import jcifs.internal.smb1.com.SmbComBlankResponse;
import jcifs.internal.smb1.com.SmbComCreateDirectory;
import jcifs.internal.smb1.com.SmbComDelete;
import jcifs.internal.smb1.com.SmbComDeleteDirectory;
import jcifs.internal.smb1.com.SmbComNTCreateAndX;
import jcifs.internal.smb1.com.SmbComNTCreateAndXResponse;
import jcifs.internal.smb1.com.SmbComOpenAndX;
import jcifs.internal.smb1.com.SmbComOpenAndXResponse;
import jcifs.internal.smb1.com.SmbComQueryInformation;
import jcifs.internal.smb1.com.SmbComQueryInformationResponse;
import jcifs.internal.smb1.com.SmbComRename;
import jcifs.internal.smb1.com.SmbComSeek;
import jcifs.internal.smb1.com.SmbComSeekResponse;
import jcifs.internal.smb1.com.SmbComSetInformation;
import jcifs.internal.smb1.com.SmbComSetInformationResponse;
import jcifs.internal.smb1.trans.nt.NtTransQuerySecurityDesc;
import jcifs.internal.smb1.trans.nt.NtTransQuerySecurityDescResponse;
import jcifs.internal.smb1.trans2.Trans2QueryFSInformation;
import jcifs.internal.smb1.trans2.Trans2QueryFSInformationResponse;
import jcifs.internal.smb1.trans2.Trans2QueryPathInformation;
import jcifs.internal.smb1.trans2.Trans2QueryPathInformationResponse;
import jcifs.internal.smb1.trans2.Trans2SetFileInformation;
import jcifs.internal.smb1.trans2.Trans2SetFileInformationResponse;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.smb2.create.Smb2CloseRequest;
import jcifs.internal.smb2.create.Smb2CloseResponse;
import jcifs.internal.smb2.create.Smb2CreateRequest;
import jcifs.internal.smb2.create.Smb2CreateResponse;
import jcifs.internal.smb2.info.Smb2QueryInfoRequest;
import jcifs.internal.smb2.info.Smb2QueryInfoResponse;
import jcifs.internal.smb2.info.Smb2SetInfoRequest;
import jcifs.smb.Handler;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbCopyUtil;
import jcifs.smb.SmbEnumerationUtil;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbFilenameFilter;
import jcifs.smb.SmbRandomAccessFile;
import jcifs.smb.SmbResourceLocatorImpl;
import jcifs.smb.SmbTreeConnection;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.smb.SmbUnsupportedOperationException;
import jcifs.smb.SmbWatchHandleImpl;
import jcifs.smb.WriterThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbFile
extends URLConnection
implements SmbResource,
SmbConstants {
    protected static final int ATTR_GET_MASK = Short.MAX_VALUE;
    protected static final int ATTR_SET_MASK = 12455;
    protected static final int DEFAULT_ATTR_EXPIRATION_PERIOD = 5000;
    protected static final int HASH_DOT = ".".hashCode();
    protected static final int HASH_DOT_DOT = "..".hashCode();
    private static Logger log = LoggerFactory.getLogger(SmbFile.class);
    private long createTime;
    private long lastModified;
    private long lastAccess;
    private int attributes;
    private long attrExpiration;
    private long size;
    private long sizeExpiration;
    private boolean isExists;
    private CIFSContext transportContext;
    private SmbTreeConnection treeConnection;
    protected final SmbResourceLocatorImpl fileLocator;
    private SmbTreeHandleImpl treeHandle;

    @Deprecated
    public SmbFile(String url) throws MalformedURLException {
        this(new URL(null, url, SingletonContext.getInstance().getUrlHandler()));
    }

    @Deprecated
    public SmbFile(URL url) throws MalformedURLException {
        this(url, SingletonContext.getInstance().withCredentials(new NtlmPasswordAuthentication(SingletonContext.getInstance(), url.getUserInfo())));
    }

    public SmbFile(SmbResource context, String name) throws MalformedURLException, UnknownHostException {
        this(SmbFile.isWorkgroup(context) ? new URL(null, "smb://" + SmbFile.checkName(name), context.getContext().getUrlHandler()) : new URL(context.getLocator().getURL(), SmbFile.checkName(name), context.getContext().getUrlHandler()), context.getContext());
        this.setContext(context, name);
    }

    public SmbFile(String url, CIFSContext tc) throws MalformedURLException {
        this(new URL(null, url, tc.getUrlHandler()), tc);
    }

    public SmbFile(URL url, CIFSContext tc) throws MalformedURLException {
        super(url);
        if (url.getPath() != null && !url.getPath().isEmpty() && url.getPath().charAt(0) != '/') {
            throw new MalformedURLException("Invalid SMB URL: " + url);
        }
        this.transportContext = tc;
        this.fileLocator = new SmbResourceLocatorImpl(tc, url);
        this.treeConnection = SmbTreeConnection.create(tc);
    }

    SmbFile(SmbResource context, String name, boolean loadedAttributes, int type, int attributes, long createTime, long lastModified, long lastAccess, long size) throws MalformedURLException {
        this(SmbFile.isWorkgroup(context) ? new URL(null, "smb://" + SmbFile.checkName(name) + "/", Handler.SMB_HANDLER) : new URL(context.getLocator().getURL(), SmbFile.checkName(name) + ((attributes & 0x10) > 0 ? "/" : "")), context.getContext());
        if (!SmbFile.isWorkgroup(context)) {
            this.setContext(context, name + ((attributes & 0x10) > 0 ? "/" : ""));
        }
        this.fileLocator.updateType(type);
        this.attributes = attributes;
        this.createTime = createTime;
        this.lastModified = lastModified;
        this.lastAccess = lastAccess;
        this.size = size;
        this.isExists = true;
        if (loadedAttributes) {
            this.attrExpiration = this.sizeExpiration = System.currentTimeMillis() + this.getContext().getConfig().getAttributeCacheTimeout();
        }
    }

    private static boolean isWorkgroup(SmbResource r) {
        try {
            return r.getLocator().isWorkgroup();
        }
        catch (CIFSException e) {
            log.debug("Failed to check for workgroup", (Throwable)e);
            return false;
        }
    }

    @Override
    public void connect() throws IOException {
        SmbTreeHandleImpl th = this.ensureTreeConnected();
        Throwable throwable = null;
        if (th != null) {
            if (throwable != null) {
                try {
                    th.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                th.close();
            }
        }
    }

    public SmbTreeHandle getTreeHandle() throws CIFSException {
        return this.ensureTreeConnected();
    }

    @Override
    public synchronized void close() {
        SmbTreeHandleImpl th = this.treeHandle;
        if (th != null) {
            this.treeHandle = null;
            if (this.transportContext.getConfig().isStrictResourceLifecycle()) {
                th.close();
            }
        }
    }

    synchronized SmbTreeHandleImpl ensureTreeConnected() throws CIFSException {
        if (this.treeHandle == null || !this.treeHandle.isConnected()) {
            if (this.treeHandle != null && this.transportContext.getConfig().isStrictResourceLifecycle()) {
                this.treeHandle.release();
            }
            this.treeHandle = this.treeConnection.connectWrapException(this.fileLocator);
            this.treeHandle.ensureDFSResolved();
            if (this.transportContext.getConfig().isStrictResourceLifecycle()) {
                return this.treeHandle.acquire();
            }
            return this.treeHandle;
        }
        return this.treeHandle.acquire();
    }

    private void setContext(SmbResource context, String name) {
        this.fileLocator.resolveInContext(context.getLocator(), name);
        this.treeConnection = context.getLocator().getShare() != null && context instanceof SmbFile ? SmbTreeConnection.create(((SmbFile)context).treeConnection) : SmbTreeConnection.create(context.getContext());
    }

    private static String checkName(String name) throws MalformedURLException {
        if (name == null || name.length() == 0) {
            throw new MalformedURLException("Name must not be empty");
        }
        return name;
    }

    protected void setNonPooled(boolean nonPooled) {
        this.treeConnection.setNonPooled(nonPooled);
    }

    @Deprecated
    public CIFSContext getTransportContext() {
        return this.getContext();
    }

    @Override
    public CIFSContext getContext() {
        return this.transportContext;
    }

    @Override
    public SmbResourceLocator getLocator() {
        return this.fileLocator;
    }

    @Override
    public SmbResource resolve(String name) throws CIFSException {
        try {
            if (name == null || name.length() == 0) {
                throw new SmbException("Name must not be empty");
            }
            return new SmbFile(this, name);
        }
        catch (MalformedURLException | UnknownHostException e) {
            throw new SmbException("Failed to resolve child element", (Throwable)e);
        }
    }

    SmbFileHandleImpl openUnshared(int flags, int access, int sharing, int attrs, int options) throws CIFSException {
        return this.openUnshared(this.getUncPath(), flags, access, sharing, attrs, options);
    }

    SmbFileHandleImpl openUnshared(String uncPath, int flags, int access, int sharing, int attrs, int options) throws CIFSException {
        SmbFileHandleImpl fh = null;
        try (SmbTreeHandleImpl h = this.ensureTreeConnected();){
            CommonServerMessageBlockResponse info;
            if (log.isDebugEnabled()) {
                log.debug(String.format("openUnshared: %s flags: %x access: %x attrs: %x options: %x", uncPath, flags, access, attrs, options));
            }
            Configuration config = h.getConfig();
            boolean haveSize = true;
            boolean haveAttributes = true;
            long fileSize = 0L;
            if (h.isSMB2()) {
                Smb2CreateRequest req = new Smb2CreateRequest(config, uncPath);
                req.setDesiredAccess(access);
                if ((flags & 0x40) == 64 && (flags & 0x10) == 16) {
                    req.setCreateDisposition(5);
                } else if ((flags & 0x40) == 64) {
                    req.setCreateDisposition(4);
                } else if ((flags & 0x20) == 32) {
                    req.setCreateDisposition(2);
                } else if ((flags & 0x10) == 16) {
                    req.setCreateDisposition(3);
                } else {
                    req.setCreateDisposition(1);
                }
                req.setShareAccess(sharing);
                req.setFileAttributes(attrs);
                Smb2CreateResponse resp = h.send(req, new RequestParam[0]);
                info = resp;
                fileSize = resp.getEndOfFile();
                fh = new SmbFileHandleImpl(config, resp.getFileId(), h, uncPath, flags, access, 0, 0, resp.getEndOfFile());
            } else if (h.hasCapability(16)) {
                SmbComNTCreateAndXResponse resp = new SmbComNTCreateAndXResponse(config);
                SmbComNTCreateAndX req = new SmbComNTCreateAndX(config, uncPath, flags, access, sharing, attrs, options, null);
                this.customizeCreate(req, resp);
                h.send((CommonServerMessageBlockRequest)req, resp, new RequestParam[0]);
                info = resp;
                fileSize = resp.getEndOfFile();
                this.fileLocator.updateType(resp.getFileType());
                fh = new SmbFileHandleImpl(config, resp.getFid(), h, uncPath, flags, access, attrs, options, resp.getEndOfFile());
            } else {
                SmbComOpenAndXResponse response = new SmbComOpenAndXResponse(config);
                h.send((CommonServerMessageBlockRequest)new SmbComOpenAndX(config, uncPath, access, sharing, flags, attrs, null), response, new RequestParam[0]);
                this.fileLocator.updateType(response.getFileType());
                info = response;
                fileSize = response.getDataSize();
                haveAttributes = false;
                SmbComSeek seekReq = new SmbComSeek(config, 0);
                seekReq.setMode(2);
                SmbComSeekResponse seekResp = new SmbComSeekResponse(config);
                seekReq.setFid(response.getFid());
                try {
                    h.send((CommonServerMessageBlockRequest)seekReq, seekResp, new RequestParam[0]);
                    if (log.isDebugEnabled() && seekResp.getOffset() != fileSize) {
                        log.debug(String.format("Open returned wrong size %d != %d", fileSize, seekResp.getOffset()));
                    }
                    fileSize = seekResp.getOffset();
                }
                catch (Exception e) {
                    log.debug("Seek failed", (Throwable)e);
                    haveSize = false;
                }
                fh = new SmbFileHandleImpl(config, response.getFid(), h, uncPath, flags, access, 0, 0, fileSize);
            }
            long attrTimeout = System.currentTimeMillis() + config.getAttributeCacheTimeout();
            if (haveSize) {
                this.size = fileSize;
                this.sizeExpiration = attrTimeout;
            }
            if (haveAttributes) {
                this.createTime = info.getCreateTime();
                this.lastModified = info.getLastWriteTime();
                this.lastAccess = info.getLastAccessTime();
                this.attributes = info.getAttributes() & Short.MAX_VALUE;
                this.attrExpiration = attrTimeout;
            }
            this.isExists = true;
            SmbFileHandleImpl smbFileHandleImpl = fh;
            return smbFileHandleImpl;
        }
    }

    public String getUncPath() {
        return this.fileLocator.getUNCPath();
    }

    protected void customizeCreate(SmbComNTCreateAndX request, SmbComNTCreateAndXResponse response) {
    }

    SmbBasicFileInfo queryPath(SmbTreeHandleImpl th, String path, int infoLevel) throws CIFSException {
        if (log.isDebugEnabled()) {
            log.debug("queryPath: " + path);
        }
        if (th.isSMB2()) {
            return (SmbBasicFileInfo)this.withOpen(th, null, new ServerMessageBlock2Request[0]);
        }
        if (th.hasCapability(16)) {
            Trans2QueryPathInformationResponse response = new Trans2QueryPathInformationResponse(th.getConfig(), infoLevel);
            response = th.send((CommonServerMessageBlockRequest)new Trans2QueryPathInformation(th.getConfig(), path, infoLevel), response, new RequestParam[0]);
            if (log.isDebugEnabled()) {
                log.debug("Path information " + response);
            }
            BasicFileInformation info = response.getInfo(BasicFileInformation.class);
            this.isExists = true;
            if (info instanceof FileBasicInfo) {
                this.attributes = info.getAttributes() & Short.MAX_VALUE;
                this.createTime = info.getCreateTime();
                this.lastModified = info.getLastWriteTime();
                this.lastAccess = info.getLastAccessTime();
                this.attrExpiration = System.currentTimeMillis() + th.getConfig().getAttributeCacheTimeout();
            } else if (info instanceof FileStandardInfo) {
                this.size = info.getSize();
                this.sizeExpiration = System.currentTimeMillis() + th.getConfig().getAttributeCacheTimeout();
            }
            return info;
        }
        SmbComQueryInformationResponse response = new SmbComQueryInformationResponse(th.getConfig(), th.getServerTimeZoneOffset());
        response = th.send((CommonServerMessageBlockRequest)new SmbComQueryInformation(th.getConfig(), path), response, new RequestParam[0]);
        if (log.isDebugEnabled()) {
            log.debug("Legacy path information " + response);
        }
        this.isExists = true;
        this.attributes = response.getAttributes() & Short.MAX_VALUE;
        this.lastModified = response.getLastWriteTime();
        this.attrExpiration = System.currentTimeMillis() + th.getConfig().getAttributeCacheTimeout();
        this.size = response.getSize();
        this.sizeExpiration = System.currentTimeMillis() + th.getConfig().getAttributeCacheTimeout();
        return response;
    }

    @Override
    public boolean exists() throws SmbException {
        if (this.attrExpiration > System.currentTimeMillis()) {
            log.trace("Using cached attributes");
            return this.isExists;
        }
        this.attributes = 17;
        this.createTime = 0L;
        this.lastModified = 0L;
        this.lastAccess = 0L;
        this.isExists = false;
        try {
            if (this.url.getHost().length() != 0) {
                if (this.fileLocator.getShare() == null) {
                    if (this.fileLocator.getType() == 2) {
                        this.getContext().getNameServiceClient().getByName(this.url.getHost(), true);
                    } else {
                        this.getContext().getNameServiceClient().getByName(this.url.getHost()).getHostName();
                    }
                } else {
                    try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
                        if (this.fileLocator.getType() == 8) {
                            SmbTreeHandleImpl th2 = this.ensureTreeConnected();
                            Throwable throwable = null;
                            if (th2 != null) {
                                if (throwable != null) {
                                    try {
                                        th2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                } else {
                                    th2.close();
                                }
                            }
                        } else {
                            this.queryPath(th, this.fileLocator.getUNCPath(), 4);
                        }
                    }
                }
            }
            this.isExists = true;
        }
        catch (UnknownHostException uhe) {
            log.debug("Unknown host", (Throwable)uhe);
        }
        catch (SmbException se) {
            log.trace("exists:", (Throwable)se);
            switch (se.getNtStatus()) {
                case -1073741809: 
                case -1073741773: 
                case -1073741772: 
                case -1073741766: {
                    break;
                }
                default: {
                    throw se;
                }
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
        this.attrExpiration = System.currentTimeMillis() + this.getContext().getConfig().getAttributeCacheTimeout();
        return this.isExists;
    }

    @Override
    public int getType() throws SmbException {
        try {
            int t = this.fileLocator.getType();
            if (t == 8) {
                try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
                    this.fileLocator.updateType(th.getTreeType());
                }
            }
            return t;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public String getName() {
        return this.fileLocator.getName();
    }

    public String getParent() {
        return this.fileLocator.getParent();
    }

    public String getPath() {
        return this.fileLocator.getPath();
    }

    public String getCanonicalUncPath() {
        return this.fileLocator.getCanonicalURL();
    }

    public String getDfsPath() throws SmbException {
        try {
            String path = this.treeConnection.ensureDFSResolved(this.fileLocator).getDfsPath();
            if (path != null && this.isDirectory()) {
                path = path + '/';
            }
            return path;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    public String getCanonicalPath() {
        return this.fileLocator.getCanonicalURL();
    }

    public String getShare() {
        return this.fileLocator.getShare();
    }

    public String getServerWithDfs() {
        return this.fileLocator.getServerWithDfs();
    }

    public String getServer() {
        return this.fileLocator.getServer();
    }

    @Override
    public SmbWatchHandle watch(int filter, boolean recursive) throws CIFSException {
        if (filter == 0) {
            throw new IllegalArgumentException("filter must not be 0");
        }
        if (!this.isDirectory()) {
            throw new SmbException("Is not a directory");
        }
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            if (!th.isSMB2() && !th.hasCapability(16)) {
                throw new SmbUnsupportedOperationException("Not supported without CAP_NT_SMBS");
            }
            SmbWatchHandleImpl smbWatchHandleImpl = new SmbWatchHandleImpl(this.openUnshared(1, -2147352576, 7, 0, 1), filter, recursive);
            return smbWatchHandleImpl;
        }
    }

    @Override
    public boolean canRead() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists();
    }

    @Override
    public boolean canWrite() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists() && (this.attributes & 1) == 0;
    }

    @Override
    public boolean isDirectory() throws SmbException {
        if (this.fileLocator.isRootOrShare()) {
            return true;
        }
        if (!this.exists()) {
            return false;
        }
        return (this.attributes & 0x10) == 16;
    }

    @Override
    public boolean isFile() throws SmbException {
        if (this.fileLocator.isRootOrShare()) {
            return false;
        }
        this.exists();
        return (this.attributes & 0x10) == 0;
    }

    @Override
    public boolean isHidden() throws SmbException {
        if (this.fileLocator.getShare() == null) {
            return false;
        }
        if (this.fileLocator.isRootOrShare()) {
            return this.fileLocator.getShare().endsWith("$");
        }
        this.exists();
        return (this.attributes & 2) == 2;
    }

    @Override
    public long createTime() throws SmbException {
        if (!this.fileLocator.isRootOrShare()) {
            this.exists();
            return this.createTime;
        }
        return 0L;
    }

    @Override
    public long lastModified() throws SmbException {
        if (!this.fileLocator.isRootOrShare()) {
            this.exists();
            return this.lastModified;
        }
        return 0L;
    }

    @Override
    public long lastAccess() throws SmbException {
        if (!this.fileLocator.isRootOrShare()) {
            this.exists();
            return this.lastAccess;
        }
        return 0L;
    }

    public String[] list() throws SmbException {
        return SmbEnumerationUtil.list(this, "*", 22, null, null);
    }

    public String[] list(SmbFilenameFilter filter) throws SmbException {
        return SmbEnumerationUtil.list(this, "*", 22, filter, null);
    }

    public SmbFile[] listFiles() throws SmbException {
        return SmbEnumerationUtil.listFiles(this, "*", 22, null, null);
    }

    public SmbFile[] listFiles(String wildcard) throws SmbException {
        return SmbEnumerationUtil.listFiles(this, wildcard, 22, null, null);
    }

    public SmbFile[] listFiles(SmbFilenameFilter filter) throws SmbException {
        return SmbEnumerationUtil.listFiles(this, "*", 22, filter, null);
    }

    public SmbFile[] listFiles(SmbFileFilter filter) throws SmbException {
        return SmbEnumerationUtil.listFiles(this, "*", 22, null, filter);
    }

    @Override
    public CloseableIterator<SmbResource> children() throws CIFSException {
        return SmbEnumerationUtil.doEnum(this, "*", 22, null, null);
    }

    @Override
    public CloseableIterator<SmbResource> children(String wildcard) throws CIFSException {
        return SmbEnumerationUtil.doEnum(this, wildcard, 22, null, null);
    }

    @Override
    public CloseableIterator<SmbResource> children(ResourceNameFilter filter) throws CIFSException {
        return SmbEnumerationUtil.doEnum(this, "*", 22, filter, null);
    }

    @Override
    public CloseableIterator<SmbResource> children(ResourceFilter filter) throws CIFSException {
        return SmbEnumerationUtil.doEnum(this, "*", 22, null, filter);
    }

    @Override
    public void renameTo(SmbResource d) throws SmbException {
        this.renameTo(d, false);
    }

    @Override
    public void renameTo(SmbResource d, boolean replace) throws SmbException {
        if (!(d instanceof SmbFile)) {
            throw new SmbException("Invalid target resource");
        }
        SmbFile dest = (SmbFile)d;
        try (SmbTreeHandleImpl sh = this.ensureTreeConnected();
             SmbTreeHandleImpl th = dest.ensureTreeConnected();){
            if (!this.exists()) {
                throw new SmbException(-1073741772, null);
            }
            dest.exists();
            if (this.fileLocator.isRootOrShare() || dest.fileLocator.isRootOrShare()) {
                throw new SmbException("Invalid operation for workgroups, servers, or shares");
            }
            if (!sh.isSameTree(th)) {
                this.exists();
                dest.exists();
                if (!sh.isSameTree(th)) {
                    throw new SmbException("Cannot rename between different trees");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("renameTo: " + this.getUncPath() + " -> " + dest.getUncPath());
            }
            dest.sizeExpiration = 0L;
            dest.attrExpiration = 0L;
            if (sh.isSMB2()) {
                Smb2SetInfoRequest req = new Smb2SetInfoRequest(sh.getConfig());
                req.setFileInformation(new FileRenameInformation2(dest.getUncPath().substring(1), replace));
                this.withOpen(sh, 1, 65792, 3, req, new ServerMessageBlock2Request[0]);
            } else {
                if (replace) {
                    throw new SmbUnsupportedOperationException("Replacing rename only supported with SMB2");
                }
                sh.send((CommonServerMessageBlockRequest)new SmbComRename(sh.getConfig(), this.getUncPath(), dest.getUncPath()), new SmbComBlankResponse(sh.getConfig()), new RequestParam[0]);
            }
            this.sizeExpiration = 0L;
            this.attrExpiration = 0L;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    void copyRecursive(SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh) throws CIFSException {
        if (this.isDirectory()) {
            SmbCopyUtil.copyDir(this, dest, b, bsize, w, sh, dh);
        } else {
            SmbCopyUtil.copyFile(this, dest, b, bsize, w, sh, dh);
        }
        dest.clearAttributeCache();
    }

    void clearAttributeCache() {
        this.attrExpiration = 0L;
        this.sizeExpiration = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(SmbResource d) throws SmbException {
        if (!(d instanceof SmbFile)) {
            throw new SmbException("Invalid target resource");
        }
        SmbFile dest = (SmbFile)d;
        try (SmbTreeHandleImpl sh = this.ensureTreeConnected();
             SmbTreeHandleImpl dh = dest.ensureTreeConnected();){
            if (!this.exists()) {
                throw new SmbException(-1073741772, null);
            }
            if (this.fileLocator.getShare() == null || dest.getLocator().getShare() == null) {
                throw new SmbException("Invalid operation for workgroups or servers");
            }
            if (this.fileLocator.overlaps(dest.getLocator())) {
                throw new SmbException("Source and destination paths overlap.");
            }
            WriterThread w = new WriterThread();
            w.setDaemon(true);
            try {
                w.start();
                int bsize = Math.min(sh.getReceiveBufferSize() - 70, dh.getSendBufferSize() - 70);
                byte[][] b = new byte[2][bsize];
                this.copyRecursive(dest, b, bsize, w, sh, dh);
            }
            finally {
                w.write(null, -1, null);
                w.interrupt();
                try {
                    w.join();
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while joining copy thread", (Throwable)e);
                }
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public void delete() throws SmbException {
        try {
            this.delete(this.fileLocator.getUNCPath());
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
        this.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void delete(String fileName) throws CIFSException {
        if (this.fileLocator.isRootOrShare()) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            Smb2CreateRequest req;
            if (!this.exists()) {
                throw new SmbException(-1073741772, null);
            }
            if ((this.attributes & 1) != 0) {
                this.setReadWrite();
            }
            if (log.isDebugEnabled()) {
                log.debug("delete: " + fileName);
            }
            if ((this.attributes & 0x10) != 0) {
                block49: {
                    try (CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(this, "*", 22, null, null);){
                        while (it.hasNext()) {
                            SmbResource r;
                            block48: {
                                r = (SmbResource)it.next();
                                Throwable throwable = null;
                                try {
                                    try {
                                        r.delete();
                                    }
                                    catch (CIFSException e) {
                                        throw SmbException.wrap(e);
                                    }
                                    if (r == null) continue;
                                    if (throwable == null) break block48;
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (r == null) throw throwable3;
                                        if (throwable == null) {
                                            r.close();
                                            throw throwable3;
                                        }
                                        try {
                                            r.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                            throw throwable3;
                                        }
                                    }
                                }
                                try {
                                    r.close();
                                    continue;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    continue;
                                }
                            }
                            r.close();
                        }
                    }
                    catch (SmbException se) {
                        log.debug("delete", (Throwable)se);
                        if (se.getNtStatus() == -1073741809) break block49;
                        throw se;
                    }
                }
                if (th.isSMB2()) {
                    req = new Smb2CreateRequest(th.getConfig(), fileName);
                    req.setDesiredAccess(65536);
                    req.setCreateOptions(4097);
                    req.setCreateDisposition(1);
                    req.chain(new Smb2CloseRequest(th.getConfig(), fileName));
                    th.send(req, new RequestParam[0]);
                } else {
                    th.send((CommonServerMessageBlockRequest)new SmbComDeleteDirectory(th.getConfig(), fileName), new SmbComBlankResponse(th.getConfig()), new RequestParam[0]);
                }
            } else if (th.isSMB2()) {
                req = new Smb2CreateRequest(th.getConfig(), fileName.substring(1));
                req.setDesiredAccess(65536);
                req.setCreateOptions(4096);
                req.chain(new Smb2CloseRequest(th.getConfig(), fileName));
                th.send(req, new RequestParam[0]);
            } else {
                th.send((CommonServerMessageBlockRequest)new SmbComDelete(th.getConfig(), fileName), new SmbComBlankResponse(th.getConfig()), new RequestParam[0]);
            }
            this.sizeExpiration = 0L;
            this.attrExpiration = 0L;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long length() throws SmbException {
        if (this.sizeExpiration > System.currentTimeMillis()) {
            return this.size;
        }
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            int t = this.getType();
            if (t == 8) {
                this.size = this.fetchAllocationInfo(th).getCapacity();
            } else if (!this.fileLocator.isRoot() && t != 16) {
                this.queryPath(th, this.fileLocator.getUNCPath(), 5);
            } else {
                this.size = 0L;
            }
            this.sizeExpiration = System.currentTimeMillis() + this.getContext().getConfig().getAttributeCacheTimeout();
            long l = this.size;
            return l;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getDiskFreeSpace() throws SmbException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            int t = this.getType();
            if (t == 8 || t == 1) {
                AllocInfo allocInfo = this.fetchAllocationInfo(th);
                this.size = allocInfo.getCapacity();
                this.sizeExpiration = System.currentTimeMillis() + this.getContext().getConfig().getAttributeCacheTimeout();
                long l = allocInfo.getFree();
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    private AllocInfo fetchAllocationInfo(SmbTreeHandleImpl th) throws CIFSException, SmbException {
        AllocInfo ai;
        try {
            ai = this.queryFSInformation(th, AllocInfo.class, (byte)3);
        }
        catch (SmbException ex) {
            log.debug("getDiskFreeSpace", (Throwable)ex);
            switch (ex.getNtStatus()) {
                case -1073741823: 
                case -1073741821: {
                    if (!th.isSMB2()) {
                        ai = this.queryFSInformation(th, AllocInfo.class, (byte)-1);
                        break;
                    }
                }
                default: {
                    throw ex;
                }
            }
        }
        return ai;
    }

    private <T extends FileSystemInformation> T queryFSInformation(SmbTreeHandleImpl th, Class<T> clazz, byte level) throws CIFSException {
        if (th.isSMB2()) {
            Smb2QueryInfoRequest qreq = new Smb2QueryInfoRequest(th.getConfig());
            qreq.setFilesystemInfoClass(level);
            Smb2QueryInfoResponse resp = this.withOpen(th, qreq, new ServerMessageBlock2Request[0]);
            return (T)((FileSystemInformation)resp.getInfo(clazz));
        }
        Trans2QueryFSInformationResponse response = new Trans2QueryFSInformationResponse(th.getConfig(), (int)level);
        th.send((CommonServerMessageBlockRequest)new Trans2QueryFSInformation(th.getConfig(), (int)level), response, new RequestParam[0]);
        return response.getInfo(clazz);
    }

    @Override
    public void mkdir() throws SmbException {
        String path = this.fileLocator.getUNCPath();
        if (path.length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            this.exists();
            path = this.fileLocator.getUNCPath();
            if (log.isDebugEnabled()) {
                log.debug("mkdir: " + path);
            }
            if (th.isSMB2()) {
                Smb2CreateRequest req = new Smb2CreateRequest(th.getConfig(), path);
                req.setCreateDisposition(2);
                req.setCreateOptions(1);
                req.chain(new Smb2CloseRequest(th.getConfig(), path));
                th.send(req, new RequestParam[0]);
            } else {
                th.send((CommonServerMessageBlockRequest)new SmbComCreateDirectory(th.getConfig(), path), new SmbComBlankResponse(th.getConfig()), new RequestParam[0]);
            }
            this.sizeExpiration = 0L;
            this.attrExpiration = 0L;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public void mkdirs() throws SmbException {
        String p = this.fileLocator.getParent();
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();
             SmbFile parent = new SmbFile(p, this.getContext());){
            try {
                if (!parent.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Parent does not exist " + p);
                    }
                    parent.mkdirs();
                }
            }
            catch (SmbException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to ensure parent exists " + p, (Throwable)e);
                }
                throw e;
            }
            try {
                this.mkdir();
            }
            catch (SmbException e) {
                log.debug("mkdirs", (Throwable)e);
                if (e.getNtStatus() != -1073741771) {
                    throw e;
                }
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
        catch (MalformedURLException e) {
            throw new SmbException("Invalid URL in mkdirs", (Throwable)e);
        }
    }

    protected <T extends ServerMessageBlock2Response> T withOpen(SmbTreeHandleImpl th, ServerMessageBlock2Request<T> first, ServerMessageBlock2Request<?> ... others) throws CIFSException {
        return this.withOpen(th, 1, 1179785, 3, first, others);
    }

    protected <T extends ServerMessageBlock2Response> T withOpen(SmbTreeHandleImpl th, int createDisposition, int desiredAccess, int shareAccess, ServerMessageBlock2Request<T> first, ServerMessageBlock2Request<?> ... others) throws CIFSException {
        return this.withOpen(th, createDisposition, 0, 128, desiredAccess, shareAccess, first, others);
    }

    protected <T extends ServerMessageBlock2Response> T withOpen(SmbTreeHandleImpl th, int createDisposition, int createOptions, int fileAttributes, int desiredAccess, int shareAccess, ServerMessageBlock2Request<T> first, ServerMessageBlock2Request<?> ... others) throws CIFSException {
        Smb2CreateRequest cr = new Smb2CreateRequest(th.getConfig(), this.getUncPath());
        try {
            cr.setCreateDisposition(createDisposition);
            cr.setCreateOptions(createOptions);
            cr.setFileAttributes(fileAttributes);
            cr.setDesiredAccess(desiredAccess);
            cr.setShareAccess(shareAccess);
            ServerMessageBlock2Request cur = cr;
            if (first != null) {
                cr.chain(first);
                cur = first;
                for (ServerMessageBlock2Request<?> req : others) {
                    cur.chain(req);
                    cur = req;
                }
            }
            Smb2CloseRequest closeReq = new Smb2CloseRequest(th.getConfig(), this.getUncPath());
            closeReq.setCloseFlags(1);
            cur.chain(closeReq);
            Smb2CreateResponse createResp = th.send(cr, new RequestParam[0]);
            Smb2CloseResponse closeResp = (Smb2CloseResponse)closeReq.getResponse();
            ServerMessageBlock2Response info = (closeResp.getCloseFlags() & 1) != 0 ? closeResp : createResp;
            this.isExists = true;
            this.createTime = info.getCreateTime();
            this.lastModified = info.getLastWriteTime();
            this.lastAccess = info.getLastAccessTime();
            this.attributes = info.getAttributes() & Short.MAX_VALUE;
            this.attrExpiration = System.currentTimeMillis() + th.getConfig().getAttributeCacheTimeout();
            this.size = info.getSize();
            this.sizeExpiration = System.currentTimeMillis() + th.getConfig().getAttributeCacheTimeout();
            return (T)((ServerMessageBlock2Response)createResp.getNextResponse());
        }
        catch (RuntimeException | CIFSException e) {
            try {
                Smb2CreateResponse createResp = (Smb2CreateResponse)cr.getResponse();
                if (createResp.isReceived() && createResp.getStatus() == 0) {
                    th.send(new Smb2CloseRequest(th.getConfig(), createResp.getFileId()), RequestParam.NO_RETRY);
                }
            }
            catch (Exception e2) {
                log.debug("Failed to close after failure", (Throwable)e2);
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @Override
    public void createNewFile() throws SmbException {
        block28: {
            if (this.fileLocator.isRootOrShare()) {
                throw new SmbException("Invalid operation for workgroups, servers, or shares");
            }
            try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
                if (th.isSMB2()) {
                    this.withOpen(th, 3, 3, 0, null, new ServerMessageBlock2Request[0]);
                    break block28;
                }
                try (SmbFileHandleImpl fd = this.openUnshared(51, 3, 0, 128, 0);){
                    fd.close(0L);
                }
            }
            catch (CIFSException e) {
                throw SmbException.wrap(e);
            }
        }
    }

    void setPathInformation(int attrs, long ctime, long mtime, long atime) throws CIFSException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            if (!this.exists()) {
                throw new SmbException(-1073741772, null);
            }
            int dir = this.attributes & 0x10;
            if (th.isSMB2()) {
                Smb2SetInfoRequest req = new Smb2SetInfoRequest(th.getConfig());
                req.setFileInformation(new FileBasicInfo(ctime, atime, mtime, 0L, attrs | dir));
                this.withOpen(th, 1, 256, 3, req, new ServerMessageBlock2Request[0]);
            } else if (th.hasCapability(16)) {
                try (SmbFileHandleImpl f = this.openUnshared(1, 256, 3, dir, dir != 0 ? 1 : 64);){
                    th.send((CommonServerMessageBlockRequest)new Trans2SetFileInformation(th.getConfig(), f.getFid(), attrs | dir, ctime, mtime, atime), new Trans2SetFileInformationResponse(th.getConfig()), RequestParam.NO_RETRY);
                }
            } else {
                if (ctime != 0L || atime != 0L) {
                    throw new SmbUnsupportedOperationException("Cannot set creation or access time without CAP_NT_SMBS");
                }
                th.send((CommonServerMessageBlockRequest)new SmbComSetInformation(th.getConfig(), this.getUncPath(), attrs, mtime - th.getServerTimeZoneOffset()), new SmbComSetInformationResponse(th.getConfig()), new RequestParam[0]);
            }
            this.attrExpiration = 0L;
        }
    }

    @Override
    public void setCreateTime(long time) throws SmbException {
        if (this.fileLocator.isRootOrShare()) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        try {
            this.setPathInformation(0, time, 0L, 0L);
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public void setLastModified(long time) throws SmbException {
        if (this.fileLocator.isRootOrShare()) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        try {
            this.setPathInformation(0, 0L, time, 0L);
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public void setLastAccess(long time) throws SmbException {
        if (this.fileLocator.isRootOrShare()) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        try {
            this.setPathInformation(0, 0L, 0L, time);
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public int getAttributes() throws SmbException {
        if (this.fileLocator.isRootOrShare()) {
            return 0;
        }
        this.exists();
        return this.attributes & Short.MAX_VALUE;
    }

    @Override
    public void setAttributes(int attrs) throws SmbException {
        if (this.fileLocator.isRootOrShare()) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        try {
            this.setPathInformation(attrs & 0x30A7, 0L, 0L, 0L);
        }
        catch (SmbException e) {
            if (e.getNtStatus() != -1073741637) {
                throw e;
            }
            throw new SmbUnsupportedOperationException("Attribute not supported by server");
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public void setReadOnly() throws SmbException {
        this.setAttributes(this.getAttributes() | 1);
    }

    @Override
    public void setReadWrite() throws SmbException {
        this.setAttributes(this.getAttributes() & 0xFFFFFFFE);
    }

    @Deprecated
    public URL toURL() {
        return this.getURL();
    }

    public int hashCode() {
        return this.fileLocator.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmbFile) {
            SmbResource f = (SmbResource)obj;
            if (this == f) {
                return true;
            }
            return this.fileLocator.equals(f.getLocator());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.url.toString();
    }

    @Override
    @Deprecated
    public int getContentLength() {
        try {
            return (int)(this.length() & 0xFFFFFFFFL);
        }
        catch (SmbException se) {
            log.debug("getContentLength", (Throwable)se);
            return 0;
        }
    }

    @Override
    public long getContentLengthLong() {
        try {
            return this.length();
        }
        catch (SmbException se) {
            log.debug("getContentLength", (Throwable)se);
            return 0L;
        }
    }

    @Override
    public long getDate() {
        try {
            return this.lastModified();
        }
        catch (SmbException se) {
            log.debug("getDate", (Throwable)se);
            return 0L;
        }
    }

    @Override
    public long getLastModified() {
        try {
            return this.lastModified();
        }
        catch (SmbException se) {
            log.debug("getLastModified", (Throwable)se);
            return 0L;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new SmbFileInputStream(this);
    }

    @Override
    public SmbFileInputStream openInputStream() throws SmbException {
        return new SmbFileInputStream(this);
    }

    @Override
    public SmbFileInputStream openInputStream(int sharing) throws SmbException {
        return this.openInputStream(0, 1, sharing);
    }

    @Override
    public SmbFileInputStream openInputStream(int flags, int access, int sharing) throws SmbException {
        return new SmbFileInputStream(this, flags, access, sharing, false);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new SmbFileOutputStream(this);
    }

    @Override
    public SmbFileOutputStream openOutputStream() throws SmbException {
        return new SmbFileOutputStream(this);
    }

    @Override
    public SmbFileOutputStream openOutputStream(boolean append) throws SmbException {
        return this.openOutputStream(append, 1);
    }

    @Override
    public SmbFileOutputStream openOutputStream(boolean append, int sharing) throws SmbException {
        return this.openOutputStream(append, append ? 22 : 82, 0, sharing);
    }

    @Override
    public SmbFileOutputStream openOutputStream(boolean append, int openFlags, int access, int sharing) throws SmbException {
        return new SmbFileOutputStream(this, append, openFlags, access, sharing);
    }

    @Override
    public SmbRandomAccessFile openRandomAccess(String mode) throws SmbException {
        return new SmbRandomAccessFile(this, mode);
    }

    @Override
    public SmbRandomAccessFile openRandomAccess(String mode, int sharing) throws SmbException {
        return new SmbRandomAccessFile(this, mode, sharing, false);
    }

    private void processAces(ACE[] aces, boolean resolveSids) throws IOException {
        String server = this.fileLocator.getServerWithDfs();
        if (resolveSids) {
            SID[] sids = new jcifs.smb.SID[aces.length];
            for (int ai = 0; ai < aces.length; ++ai) {
                sids[ai] = aces[ai].getSID();
            }
            for (int off = 0; off < sids.length; off += 64) {
                int len = sids.length - off;
                if (len > 64) {
                    len = 64;
                }
                this.getContext().getSIDResolver().resolveSids(this.getContext(), server, sids, off, len);
            }
        } else {
            for (int ai = 0; ai < aces.length; ++ai) {
                aces[ai].getSID().initContext(server, this.getContext());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long fileIndex() throws SmbException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            if (!th.isSMB2()) return 0L;
            Smb2QueryInfoRequest req = new Smb2QueryInfoRequest(th.getConfig());
            req.setFileInfoClass((byte)6);
            Smb2QueryInfoResponse resp = this.withOpen(th, req, new ServerMessageBlock2Request[0]);
            FileInternalInfo info = resp.getInfo(FileInternalInfo.class);
            long l = info.getIndexNumber();
            return l;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    SecurityDescriptor querySecurity(SmbTreeHandleImpl th, int types) throws CIFSException {
        if (th.isSMB2()) {
            Smb2QueryInfoRequest req = new Smb2QueryInfoRequest(th.getConfig());
            req.setInfoType((byte)3);
            req.setAdditionalInformation(types);
            Smb2QueryInfoResponse resp = this.withOpen(th, req, new ServerMessageBlock2Request[0]);
            return resp.getInfo(SecurityDescriptor.class);
        }
        if (!th.hasCapability(16)) {
            throw new SmbUnsupportedOperationException("Not supported without CAP_NT_SMBS/SMB2");
        }
        NtTransQuerySecurityDescResponse response = new NtTransQuerySecurityDescResponse(this.getContext().getConfig());
        try (SmbFileHandleImpl f = this.openUnshared(1, 131072, 7, 0, this.isDirectory() ? 1 : 0);){
            NtTransQuerySecurityDesc request = new NtTransQuerySecurityDesc(this.getContext().getConfig(), f.getFid(), types);
            response = th.send((CommonServerMessageBlockRequest)request, response, RequestParam.NO_RETRY);
            SecurityDescriptor securityDescriptor = response.getSecurityDescriptor();
            return securityDescriptor;
        }
    }

    public ACE[] getSecurity() throws IOException {
        return this.getSecurity(false);
    }

    public ACE[] getSecurity(boolean resolveSids) throws IOException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            SecurityDescriptor desc = this.querySecurity(th, 4);
            ACE[] aces = desc.getAces();
            if (aces != null) {
                this.processAces(aces, resolveSids);
            }
            ACE[] aCEArray = aces;
            return aCEArray;
        }
    }

    @Override
    public jcifs.smb.SID getOwnerUser() throws IOException {
        return this.getOwnerUser(true);
    }

    @Override
    public jcifs.smb.SID getOwnerUser(boolean resolve) throws IOException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            SecurityDescriptor desc = this.querySecurity(th, 1);
            jcifs.smb.SID ownerUser = desc.getOwnerUserSid();
            if (ownerUser == null) {
                jcifs.smb.SID sID = null;
                return sID;
            }
            String server = this.fileLocator.getServerWithDfs();
            if (resolve) {
                try {
                    ownerUser.resolve(server, this.getContext());
                }
                catch (IOException e) {
                    log.warn("Failed to resolve SID " + ownerUser.toString(), (Throwable)e);
                }
            } else {
                ownerUser.initContext(server, this.getContext());
            }
            jcifs.smb.SID sID = ownerUser;
            return sID;
        }
    }

    @Override
    public jcifs.smb.SID getOwnerGroup() throws IOException {
        return this.getOwnerGroup(true);
    }

    @Override
    public jcifs.smb.SID getOwnerGroup(boolean resolve) throws IOException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            SecurityDescriptor desc = this.querySecurity(th, 2);
            jcifs.smb.SID ownerGroup = desc.getOwnerGroupSid();
            if (ownerGroup == null) {
                jcifs.smb.SID sID = null;
                return sID;
            }
            String server = this.fileLocator.getServerWithDfs();
            if (resolve) {
                try {
                    ownerGroup.resolve(server, this.getContext());
                }
                catch (IOException e) {
                    log.warn("Failed to resolve SID " + ownerGroup.toString(), (Throwable)e);
                }
            } else {
                ownerGroup.initContext(server, this.getContext());
            }
            jcifs.smb.SID sID = ownerGroup;
            return sID;
        }
    }

    public ACE[] getShareSecurity(boolean resolveSids) throws IOException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            ACE[] aces;
            String server = this.fileLocator.getServerWithDfs();
            MsrpcShareGetInfo rpc2 = new MsrpcShareGetInfo(server, th.getConnectedShare());
            try (DcerpcHandle handle = DcerpcHandle.getHandle("ncacn_np:" + server + "[\\PIPE\\srvsvc]", this.getContext());){
                handle.sendrecv(rpc2);
                if (rpc2.retval != 0) {
                    throw new SmbException(rpc2.retval, true);
                }
                aces = rpc2.getSecurity();
                if (aces != null) {
                    this.processAces(aces, resolveSids);
                }
            }
            ACE[] aCEArray = aces;
            return aCEArray;
        }
    }
}

