/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.DirectoryList;

class FileCertReader {
    static Logger logger = Logger.getLogger((String)FileCertReader.class.getName());
    static final int BUF_LEN = 1000;
    static final byte CARR = 13;
    static final byte NL = 10;
    static final int TYPE_ANCHOR = 100;
    static final int TYPE_CRL = 101;
    static final int TYPE_CERT = 102;
    CertificateFactory certFactory;

    public FileCertReader() throws CertificateException {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (Exception exception) {
            logger.error((Object)("Error while creating a FileCertReader: " + exception.getMessage()));
            throw new CertificateException("Error while creating a FileCertReader: " + exception.getMessage(), exception);
        }
    }

    public FileCertReader(Provider provider) throws CertificateException {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509", provider);
        }
        catch (Exception exception) {
            logger.error((Object)("Error while creating a FileCertReader: " + exception.getMessage()));
            throw new CertificateException("Error while creating a FileCertReader: " + exception.getMessage(), exception);
        }
    }

    public FileCertReader(String string) throws CertificateException {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509", string);
        }
        catch (Exception exception) {
            logger.error((Object)("Error while creating a FileCertReader: " + exception.getMessage()));
            throw new CertificateException("Error while creating a FileCertReader: " + exception.getMessage(), exception);
        }
    }

    public Vector readCerts(String string) throws IOException, CertificateException {
        Vector vector = this.readFiles(string, 102);
        Iterator iterator = vector.iterator();
        logger.debug((Object)"read certs: ");
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            logger.debug((Object)("Read cert: " + ((Object)x509Certificate.getSubjectDN()).toString()));
        }
        return vector;
    }

    public PrivateKey readPrivateKey(String string) throws IOException {
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        FileCertReader.skipToKeyBeginning(bufferedInputStream);
        return (PrivateKey)PrivateKeyInfo.getInstance((Object)new ASN1InputStream((InputStream)bufferedInputStream).readObject()).getPrivateKey();
    }

    public Vector readAnchors(String string) throws IOException, CertificateException {
        Vector vector = this.readFiles(string, 100);
        Iterator iterator = vector.iterator();
        logger.debug((Object)"read TrustAnchors: ");
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            logger.debug((Object)("Read TrustAnchor: " + ((Object)trustAnchor.getTrustedCert().getSubjectDN()).toString()));
        }
        return vector;
    }

    public Vector readCRLs(String string) throws IOException, CertificateException {
        Vector vector = this.readFiles(string, 101);
        Iterator iterator = vector.iterator();
        logger.debug((Object)"read CRLs: ");
        while (iterator.hasNext()) {
            X509CRL x509CRL = (X509CRL)iterator.next();
            logger.debug((Object)("Read CRL: " + ((Object)x509CRL.getIssuerDN()).toString()));
        }
        return vector;
    }

    private Vector readFiles(String string, int n) throws CertificateException {
        Vector vector = new Vector();
        try {
            DirectoryList directoryList = new DirectoryList(string);
            for (File file : directoryList.getListing()) {
                vector.addAll(this.readFile(file, n));
            }
        }
        catch (IOException iOException) {
            logger.fatal((Object)("Error while reading certificates or CRLs: " + iOException.getMessage()));
            throw new CertificateException("Error while reading certificates or CRLs: " + iOException.getMessage(), iOException);
        }
        return vector;
    }

    public Vector readFile(File file, int n) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        Vector<Object> vector = new Vector<Object>();
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            while (bufferedInputStream.available() > 0) {
                Object object = this.objectReader(bufferedInputStream, n);
                if (object != null) {
                    vector.add(object);
                }
                FileCertReader.skipEmptyLines(bufferedInputStream);
            }
        }
        catch (Exception exception) {
            logger.fatal((Object)("Error while reading certificates or crls from file " + file.toString() + "error was: " + exception.getMessage()));
            throw new IOException("Error while reading certificates or crls from file " + file.toString() + "error was: " + exception.getMessage());
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return vector;
    }

    public Object objectReader(BufferedInputStream bufferedInputStream, int n) throws CertificateException, IOException {
        Object object = null;
        int n2 = 0;
        bufferedInputStream.mark(10000);
        do {
            try {
                if (n2 == 1) {
                    n2 = 2;
                    FileCertReader.skipToCertBeginning(bufferedInputStream);
                }
                bufferedInputStream.mark(100000);
                bufferedInputStream.reset();
                object = this.readObject(bufferedInputStream, n);
            }
            catch (Exception exception) {
                if (n2 != 0) {
                    logger.error((Object)("Certificate or CRL reading failed: " + exception.getMessage()));
                    throw new CertificateException("Certificate or CRL reading failed: " + exception.getMessage(), exception);
                }
                n2 = 1;
                bufferedInputStream.reset();
            }
        } while (n2 == 1);
        return object;
    }

    public Object readObject(BufferedInputStream bufferedInputStream, int n) throws CertificateException {
        Object object;
        if (n == 101) {
            try {
                object = this.certFactory.generateCRL(bufferedInputStream);
            }
            catch (CRLException cRLException) {
                logger.error((Object)("CRL loading failed: " + cRLException.getMessage()));
                throw new CertificateException(cRLException.getMessage(), cRLException);
            }
        } else {
            X509Certificate x509Certificate = (X509Certificate)this.certFactory.generateCertificate(bufferedInputStream);
            if (x509Certificate == null) {
                return null;
            }
            if (n == 100) {
                object = new TrustAnchor(x509Certificate, null);
            } else if (n == 102) {
                object = x509Certificate;
            } else {
                logger.fatal((Object)("Internal error: Invalid data type " + n + " when trying to read certificate"));
                throw new CertificateParsingException("Internal error: Invalid data type " + n + " when trying to read certificate");
            }
        }
        return object;
    }

    public static void skipToCertBeginning(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[1000];
        bufferedInputStream.mark(1002);
        while (bufferedInputStream.available() > 0) {
            int n = bufferedInputStream.read(byArray);
            String string = new String(byArray, 0, n);
            int n2 = string.indexOf("----BEGIN");
            if (n2 == -1) {
                bufferedInputStream.reset();
                bufferedInputStream.skip(900L);
                bufferedInputStream.mark(1002);
                continue;
            }
            while (string.charAt(n2 - 1) == '-' && n2 > 0 && --n2 != 0) {
            }
            bufferedInputStream.reset();
            bufferedInputStream.skip(n2);
            bufferedInputStream.mark(10000);
            return;
        }
    }

    public static void skipToKeyBeginning(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[1000];
        bufferedInputStream.mark(1002);
        while (bufferedInputStream.available() > 0) {
            int n = bufferedInputStream.read(byArray);
            String string = new String(byArray, 0, n);
            int n2 = string.indexOf("----BEGIN PRIVATE");
            if (n2 == -1) {
                n2 = string.indexOf("----BEGIN ENCRYPTED");
            }
            if (n2 == -1) {
                bufferedInputStream.reset();
                bufferedInputStream.skip(900L);
                bufferedInputStream.mark(1002);
                continue;
            }
            while (string.charAt(n2 - 1) == '-' && n2 > 0 && --n2 != 0) {
            }
            bufferedInputStream.reset();
            bufferedInputStream.skip(n2);
            bufferedInputStream.mark(10000);
            return;
        }
    }

    public static void skipEmptyLines(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[1000];
        bufferedInputStream.mark(1002);
        while (bufferedInputStream.available() > 0) {
            int n;
            int n2 = bufferedInputStream.read(byArray);
            for (n = 0; n < n2 && (byArray[n] == 13 || byArray[n] == 10); ++n) {
            }
            bufferedInputStream.reset();
            bufferedInputStream.skip(n);
            if (n < n2) {
                bufferedInputStream.mark(10000);
                return;
            }
            bufferedInputStream.mark(1000);
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

