/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.glite.voms.PKIUtils;

public class Namespace {
    private static Logger logger = Logger.getLogger((String)Namespace.class.getName());
    private static final Pattern splitPattern = Pattern.compile("to issuer|permit|deny|subject", 2);
    private Vector issuer = new Vector();
    private Vector subject = new Vector();
    private Vector permit = new Vector();
    private int current = -1;
    private String gname = "";

    public Namespace(File file) throws IOException {
        this.parse(file);
    }

    public String getName() {
        return this.gname;
    }

    void parse(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        this.gname = PKIUtils.getBaseName(file);
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if ((string = bufferedReader.readLine()) != null && !string.trim().startsWith("~")) {
                stringBuilder.append(string);
            }
            if (string != null && string.endsWith("\\")) continue;
            String string2 = stringBuilder.toString().trim();
            String[] stringArray = splitPattern.split(string2, 0);
            if (stringArray.length == 4) {
                String string3 = "";
                if (string2.toLowerCase().contains(" deny ")) {
                    string3 = "DENY";
                } else if (string2.toLowerCase().contains(" permit ")) {
                    string3 = "PERMIT";
                }
                if (!string3.equals("")) {
                    String string4 = stringArray[1];
                    if (string4.toLowerCase().equals("self")) {
                        this.issuer.add("SELF");
                    } else {
                        this.issuer.add(string4.substring(1, stringArray[1].length()));
                    }
                    this.subject.add(stringArray[3].substring(1, stringArray[3].length()));
                    this.permit.add(string3);
                }
            }
            if (string == null) break;
        }
    }

    public int findIssuer(X509Certificate x509Certificate) {
        return this.findIssuer(x509Certificate, -1);
    }

    public int findIssuer(X509Certificate x509Certificate, int n) {
        String string;
        if (n < -1) {
            return -1;
        }
        String string2 = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getSubjectDN());
        String string3 = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getSubjectDN(), true);
        int n2 = this.issuer.indexOf(string2, n + 1);
        if (n2 == -1) {
            n2 = this.issuer.indexOf(string3, n + 1);
        }
        if (n2 == -1 && ((string = PKIUtils.getHash(x509Certificate)) + ".namespace").equals(this.gname)) {
            return this.issuer.indexOf("SELF", n + 1);
        }
        return n2;
    }

    public void setCurrent(int n) {
        if (n > this.issuer.size() || n < 0) {
            throw new IllegalArgumentException("Index out of bounds for Namespace " + this.gname);
        }
        this.current = n;
    }

    public String getIssuer() {
        if (this.current != -1) {
            return (String)this.issuer.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Namespace object " + this.gname);
    }

    public String getSubject() {
        if (this.current != -1) {
            return (String)this.subject.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Namespace object " + this.gname);
    }

    public boolean getPermit() {
        if (this.current != -1) {
            return this.subject.elementAt(this.current).equals("PERMIT");
        }
        throw new IllegalArgumentException("Current record must be set in Namespace object " + this.gname);
    }
}

