/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.glite.voms.PKIStore;
import org.glite.voms.Parameters;

public class PKIStoreFactory {
    private static Hashtable stores = null;
    private static final int HASHCAPACITY = 75;
    private static Logger logger = Logger.getLogger((String)PKIStoreFactory.class.getName());

    public static synchronized PKIStore getStore(String string, int n, boolean bl, boolean bl2) throws IOException, CertificateException, CRLException {
        if (stores == null) {
            stores = new Hashtable(75);
        }
        Parameters parameters = new Parameters(string, n, bl, bl2);
        PKIStore pKIStore = null;
        pKIStore = (PKIStore)stores.get(parameters);
        if (pKIStore == null) {
            pKIStore = new PKIStore(string, n, bl, bl2);
            stores.put(parameters, pKIStore);
        } else {
            pKIStore.addInstance();
        }
        return pKIStore;
    }

    public static synchronized PKIStore getStore(String string, int n, boolean bl) throws IOException, CertificateException, CRLException {
        return PKIStoreFactory.getStore(string, n, bl, true);
    }

    public static synchronized PKIStore getStore(String string, int n) throws IOException, CertificateException, CRLException {
        return PKIStoreFactory.getStore(string, n, true, true);
    }

    public static synchronized PKIStore getStore(int n) throws IOException, CertificateException, CRLException {
        return PKIStoreFactory.getStore(null, n, true, true);
    }

    public static synchronized PKIStore getStore() {
        return new PKIStore();
    }
}

