/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIStoreFactory;
import org.glite.voms.PKIVerifier;

public class VOMSTrustManager
implements X509TrustManager {
    private PKIStore store = null;
    private PKIVerifier verifier = null;
    boolean stopcalled = false;
    private static Logger logger = Logger.getLogger((String)VOMSTrustManager.class.getName());

    public VOMSTrustManager(String string) throws IOException, CertificateException, CRLException {
        this.store = PKIStoreFactory.getStore(string, 2);
        this.verifier = new PKIVerifier(null, this.store);
        this.stopcalled = false;
    }

    public VOMSTrustManager(PKIStore pKIStore) throws IOException, CertificateException, CRLException {
        this.verifier = new PKIVerifier(null, pKIStore);
        this.store = pKIStore;
        this.stopcalled = false;
    }

    public synchronized void stop() {
        if (!this.stopcalled) {
            this.verifier.cleanup();
            this.stopcalled = true;
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray == null || string == null || x509CertificateArray.length == 0 || string.length() == 0) {
            throw new IllegalArgumentException("One of the parameters is null or empty.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Callying verify:");
            logger.debug((Object)"chain is:");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                logger.debug((Object)("HAVE TO VERIFY: " + x509CertificateArray[i].getSubjectDN()));
            }
        }
        if (this.verifier.verify(x509CertificateArray)) {
            return;
        }
        throw new CertificateException("Cannot verify certificate.  See log for details.");
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string);
    }

    public X509Certificate[] getAcceptedIssuers() {
        Hashtable hashtable = this.store.getCAs();
        ArrayList arrayList = new ArrayList(hashtable.size());
        X509Certificate[] x509CertificateArray = hashtable.elements();
        while (x509CertificateArray.hasMoreElements()) {
            Vector vector = (Vector)x509CertificateArray.nextElement();
            arrayList.addAll(vector);
        }
        x509CertificateArray = new X509Certificate[arrayList.size()];
        return arrayList.toArray(x509CertificateArray);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

