/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;

public class ACCerts
implements DEREncodable {
    List l = new Vector();

    public ACCerts() {
    }

    public ACCerts(ASN1Sequence aSN1Sequence) {
        aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ExceptionInInitializerError("Cannot find BouncyCastle provider: " + noSuchProviderException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new ExceptionInInitializerError("X.509 Certificates unsupported. " + certificateException.getMessage());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error in setting up ACCerts reader. " + exception.getMessage());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof DERSequence) {
                ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(e);
                byte[] byArray = null;
                try {
                    byArray = new X509CertificateObject(X509CertificateStructure.getInstance((Object)aSN1Sequence2)).getEncoded();
                    this.l.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Error in encoding ACCerts. " + exception.getMessage());
                }
            }
            throw new IllegalArgumentException("Incorrect encoding for ACCerts");
        }
    }

    public static ACCerts getInstance(ASN1Sequence aSN1Sequence) {
        return new ACCerts(aSN1Sequence);
    }

    public void addCert(X509CertificateStructure x509CertificateStructure) {
        this.l.add(x509CertificateStructure);
    }

    public List getCerts() {
        return this.l;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ListIterator listIterator = this.l.listIterator();
        while (listIterator.hasNext()) {
            X509CertificateStructure x509CertificateStructure = (X509CertificateStructure)listIterator.next();
            aSN1EncodableVector.add((DEREncodable)x509CertificateStructure);
        }
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

