/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.glite.voms.ac.AttCertIssuer;
import org.glite.voms.ac.AttributeCertificateInfo;
import org.glite.voms.ac.Holder;
import org.glite.voms.ac.Util;
import org.glite.voms.ac.V2Form;

public class ACGenerator {
    X500Principal issuer;
    X500Principal holderIssuer;
    BigInteger holderSerial;
    Date notAfter;
    Date notBefore;
    Vector attributes;
    Vector extensions;

    public void addAttribute(String string, String string2, String string3) {
    }

    public void addAttributes(String string, String string2, List list) {
    }

    public void setExtensions(Vector vector) {
        this.extensions = vector;
    }

    public void setHolderIssuer(X500Principal x500Principal) {
        this.holderIssuer = x500Principal;
    }

    public void setHolderSerial(BigInteger bigInteger) {
        this.holderSerial = bigInteger;
    }

    public void setIssuer(X500Principal x500Principal) {
        this.issuer = x500Principal;
    }

    public void setNotAfter(Date date) {
        this.notAfter = (Date)date.clone();
    }

    public void setNotBefore(Date date) {
        this.notBefore = (Date)date.clone();
    }

    public AttributeCertificateInfo generateACInfo() {
        if (this.issuer == null || this.holderIssuer == null || this.holderSerial == null || this.notAfter == null || this.notBefore == null) {
            throw new IllegalArgumentException("All mandatory components are not present");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)new DERInteger(1));
        aSN1EncodableVector.add((DEREncodable)new Holder(this.holderIssuer, this.holderSerial));
        aSN1EncodableVector.add((DEREncodable)new AttCertIssuer(new V2Form(Util.x500nameToGeneralNames(this.issuer))));
        aSN1EncodableVector.add((DEREncodable)new AlgorithmIdentifier("1.2.840.113549.1.1.5"));
        aSN1EncodableVector.add((DEREncodable)new DERInteger(1));
        return null;
    }

    public void sign(PrivateKey privateKey) {
    }
}

