/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.glite.voms.BasicVOMSTrustStore;
import org.glite.voms.PKIVerifier;
import org.glite.voms.ac.ACTrustStore;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.VOMSTrustStore;

public class ACValidator {
    protected static final Logger log = Logger.getLogger(ACValidator.class);
    private static ACValidator theInstance = null;
    protected ACTrustStore myTrustStore;
    protected VOMSTrustStore myVOMSStore;
    protected PKIVerifier theVerifier;

    public ACValidator(ACTrustStore aCTrustStore) {
        if (aCTrustStore == null) {
            throw new IllegalArgumentException("ACValidator: constructor must have an ACTrustStore");
        }
        this.myTrustStore = aCTrustStore;
    }

    public ACValidator(VOMSTrustStore vOMSTrustStore) {
        if (vOMSTrustStore == null) {
            throw new IllegalArgumentException("ACValidator: constructor must have a VOMSTrustStore");
        }
        this.myVOMSStore = vOMSTrustStore;
        try {
            this.theVerifier = new PKIVerifier(this.myVOMSStore);
        }
        catch (IOException iOException) {
            log.error((Object)("Problems while initializing the verifier: " + iOException.getMessage()));
            throw new IllegalArgumentException("Problems with the passed store: " + iOException.getMessage());
        }
        catch (CertificateException certificateException) {
            log.error((Object)("Problems while initializing the verifier: " + certificateException.getMessage()));
            throw new IllegalArgumentException("Problems with the passed store: " + certificateException.getMessage());
        }
        catch (CRLException cRLException) {
            log.error((Object)("Problems while initializing the verifier: " + cRLException.getMessage()));
            throw new IllegalArgumentException("Problems with the passed store: " + cRLException.getMessage());
        }
    }

    public ACValidator(PKIVerifier pKIVerifier) {
        this.myTrustStore = null;
        this.myVOMSStore = null;
        this.theVerifier = pKIVerifier;
    }

    public static ACValidator getInstance() {
        return ACValidator.getInstance((VOMSTrustStore)null);
    }

    public static ACValidator getInstance(ACTrustStore aCTrustStore) throws IllegalArgumentException {
        theInstance = theInstance != null ? theInstance : new ACValidator(aCTrustStore);
        return theInstance;
    }

    public static ACValidator getInstance(VOMSTrustStore vOMSTrustStore) throws IllegalArgumentException {
        theInstance = theInstance != null ? theInstance : new ACValidator(vOMSTrustStore);
        return theInstance;
    }

    public void cleanup() {
        if (this.myTrustStore != null && this.myTrustStore instanceof BasicVOMSTrustStore) {
            ((BasicVOMSTrustStore)this.myTrustStore).stopRefresh();
        }
        if (this.myVOMSStore != null) {
            this.myVOMSStore.stopRefresh();
        }
        if (this.theVerifier != null) {
            this.theVerifier.cleanup();
        }
    }

    public boolean validate(AttributeCertificate attributeCertificate) {
        if (attributeCertificate == null) {
            return false;
        }
        if (this.theVerifier != null) {
            return this.theVerifier.verify(attributeCertificate);
        }
        if (!attributeCertificate.isValid()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AC expired or not yet valid. Issuer : " + attributeCertificate.getIssuer().getName()));
            }
            return false;
        }
        X509Certificate[] x509CertificateArray = this.myTrustStore.getAACandidate(attributeCertificate.getIssuer());
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AC not valid (no such trusted issuer) : " + attributeCertificate.getIssuer().getName()));
            }
            return false;
        }
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            if (attributeCertificate.verify(x509CertificateArray[i].getPublicKey())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AC signature verified OK by issuer : " + x509CertificateArray[i].getSubjectX500Principal().getName()));
                }
                return true;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("AC from signature did not verify OK by issuer : " + x509CertificateArray[i].getSubjectX500Principal().getName()));
        }
        return false;
    }
}

