/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.glite.voms.FQAN;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttCertIssuer;
import org.glite.voms.ac.FullAttributes;
import org.glite.voms.ac.Holder;
import org.glite.voms.ac.IetfAttrSyntax;

public class AttributeCertificateInfo
implements DEREncodable {
    DERInteger version;
    Holder holder;
    AttCertIssuer issuer;
    AlgorithmIdentifier signature;
    DERInteger serialNumber;
    AttCertValidityPeriod attrCertValidityPeriod;
    ASN1Sequence attributes;
    DERBitString issuerUniqueID;
    X509Extensions extensions;
    boolean badVomsEncoding = false;
    FullAttributes fullAttributes = null;
    ACTargets acTargets = null;
    ACCerts acCerts = null;
    private String myVo = null;
    private String myHostPort = null;
    private Vector myStringList = new Vector();
    private Vector myFQANs = new Vector();
    private String myHost = null;
    private int myPort = -1;
    public static final String AC_TARGET_OID = "2.5.29.55";
    public static final String AC_CERTS_OID = "1.3.6.1.4.1.8005.100.100.10";
    public static final String AC_FULL_ATTRIBUTES_OID = "1.3.6.1.4.1.8005.100.100.11";
    public static final String VOMS_EXT_OID = "1.3.6.1.4.1.8005.100.100.5";
    public static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";

    public AttributeCertificateInfo(ASN1Sequence aSN1Sequence) {
        Object object;
        Object object2;
        ASN1Sequence aSN1Sequence2;
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(AC_TARGET_OID);
        DERObjectIdentifier dERObjectIdentifier2 = new DERObjectIdentifier(AC_CERTS_OID);
        DERObjectIdentifier dERObjectIdentifier3 = new DERObjectIdentifier(AC_FULL_ATTRIBUTES_OID);
        this.version = (DERInteger)aSN1Sequence.getObjectAt(0);
        this.holder = new Holder((ASN1Sequence)aSN1Sequence.getObjectAt(1));
        this.issuer = new AttCertIssuer(aSN1Sequence.getObjectAt(2));
        this.signature = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.getObjectAt(3));
        this.serialNumber = (DERInteger)aSN1Sequence.getObjectAt(4);
        ASN1Sequence aSN1Sequence3 = aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(5);
        if (aSN1Sequence2.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.badVomsEncoding = true;
            object2 = new ASN1EncodableVector();
            for (int i = 0; i < 2; ++i) {
                object = ((DEROctetString)((ASN1TaggedObject)aSN1Sequence2.getObjectAt(i)).getObject()).getOctets();
                object2.add((DEREncodable)new DERGeneralizedTime(new String((byte[])object)));
            }
            aSN1Sequence3 = new DERSequence((DEREncodableVector)object2);
        }
        this.attrCertValidityPeriod = new AttCertValidityPeriod(aSN1Sequence3);
        this.attributes = (ASN1Sequence)aSN1Sequence.getObjectAt(6);
        if (this.attributes != null && this.attributes.size() != 0) {
            object2 = this.attributes.getObjects();
            while (object2.hasMoreElements()) {
                ASN1Sequence aSN1Sequence4 = (ASN1Sequence)object2.nextElement();
                if (!VOMS_ATTR_OID.equals(((DERObjectIdentifier)aSN1Sequence4.getObjectAt(0)).getId())) continue;
                object = (DERSet)aSN1Sequence4.getObjectAt(1);
                Enumeration enumeration = object.getObjects();
                while (enumeration.hasMoreElements()) {
                    IetfAttrSyntax ietfAttrSyntax = new IetfAttrSyntax((ASN1Sequence)enumeration.nextElement());
                    String string = ((DERIA5String)GeneralName.getInstance((Object)((ASN1Sequence)ietfAttrSyntax.getPolicyAuthority().getDERObject()).getObjectAt(0)).getName()).getString();
                    int n = string.indexOf("://");
                    if (n < 0 || n == string.length() - 1) {
                        throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + string + "]");
                    }
                    this.myVo = string.substring(0, n);
                    this.myHostPort = string.substring(n + 3);
                    n = this.myHostPort.lastIndexOf(58);
                    if (n < 0 || n == this.myHostPort.length() - 1) {
                        throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + string + "]");
                    }
                    this.myHost = this.myHostPort.substring(0, n);
                    this.myPort = Integer.parseInt(this.myHostPort.substring(n + 1));
                    if (ietfAttrSyntax.getValueType() != 1) {
                        throw new IllegalArgumentException("VOMS attribute values are not encoded as octet strings, policyAuthority = " + string);
                    }
                    Iterator iterator = ietfAttrSyntax.getValues().iterator();
                    while (iterator.hasNext()) {
                        String string2 = new String(((ASN1OctetString)iterator.next()).getOctets());
                        FQAN fQAN = new FQAN(string2);
                        if (this.myStringList.contains(string2) || !string2.startsWith("/" + this.myVo + "/") && !string2.equals("/" + this.myVo)) continue;
                        this.myStringList.add(string2);
                        this.myFQANs.add(fQAN);
                    }
                }
            }
        }
        if (aSN1Sequence.size() > 8) {
            this.issuerUniqueID = new DERBitString(aSN1Sequence.getObjectAt(7));
            this.extensions = new X509Extensions((ASN1Sequence)aSN1Sequence.getObjectAt(8));
        } else if (aSN1Sequence.size() > 7) {
            this.extensions = new X509Extensions((ASN1Sequence)aSN1Sequence.getObjectAt(7));
        }
        if (this.extensions.getExtension(dERObjectIdentifier) != null) {
            object2 = this.extensions.getExtension(dERObjectIdentifier).getValue().getOctets();
            DERObject dERObject = null;
            try {
                dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object2)).readObject();
                this.acTargets = new ACTargets(ASN1Sequence.getInstance((Object)dERObject));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("DERO: " + exception.getMessage());
            }
        }
        if (this.extensions.getExtension(dERObjectIdentifier2) != null) {
            object2 = this.extensions.getExtension(dERObjectIdentifier2).getValue().getOctets();
            DERObject dERObject = null;
            try {
                dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object2)).readObject();
                this.acCerts = new ACCerts(ASN1Sequence.getInstance((Object)dERObject));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("DERO: " + exception.getMessage());
            }
        }
        if (this.extensions.getExtension(dERObjectIdentifier3) != null) {
            object2 = this.extensions.getExtension(dERObjectIdentifier3).getValue().getOctets();
            DERObject dERObject = null;
            try {
                dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object2)).readObject();
                this.fullAttributes = new FullAttributes(ASN1Sequence.getInstance((Object)dERObject));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("DERO: " + exception.getMessage());
            }
        }
    }

    public static AttributeCertificateInfo getInstance(ASN1Sequence aSN1Sequence) {
        return new AttributeCertificateInfo(aSN1Sequence);
    }

    public DERInteger getAttCertVersion() {
        return this.version;
    }

    public Holder getHolder() {
        return this.holder;
    }

    public AttCertIssuer getIssuer() {
        return this.issuer;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.attrCertValidityPeriod;
    }

    public ASN1Sequence getAttributes() {
        return this.attributes;
    }

    public String getVO() {
        return this.myVo;
    }

    public String getHostPort() {
        return this.myHostPort;
    }

    public String getHost() {
        return this.myHost;
    }

    public int getPort() {
        return this.myPort;
    }

    public DERBitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public FullAttributes getFullAttributes() {
        return this.fullAttributes;
    }

    public ACCerts getCertList() {
        return this.acCerts;
    }

    public ACTargets getTargets() {
        return this.acTargets;
    }

    public List getFullyQualifiedAttributes() {
        return this.myStringList;
    }

    public List getListOfFQAN() {
        return this.myFQANs;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)this.version);
        aSN1EncodableVector.add((DEREncodable)this.holder);
        aSN1EncodableVector.add((DEREncodable)this.issuer);
        aSN1EncodableVector.add((DEREncodable)this.signature);
        aSN1EncodableVector.add((DEREncodable)this.serialNumber);
        if (!this.badVomsEncoding) {
            aSN1EncodableVector.add((DEREncodable)this.attrCertValidityPeriod);
        } else {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)new DEROctetString((this.attrCertValidityPeriod.getNotBeforeTime().getTime().substring(0, 14) + "Z").getBytes())));
            aSN1EncodableVector2.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)new DEROctetString((this.attrCertValidityPeriod.getNotAfterTime().getTime().substring(0, 14) + "Z").getBytes())));
            aSN1EncodableVector.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector2));
        }
        aSN1EncodableVector.add((DEREncodable)this.attributes);
        if (this.issuerUniqueID != null) {
            aSN1EncodableVector.add((DEREncodable)this.issuerUniqueID);
        }
        if (this.extensions != null) {
            aSN1EncodableVector.add((DEREncodable)this.extensions);
        }
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

