/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.x509.GeneralNames;

public class IetfAttrSyntax
implements DEREncodable {
    public static final int VALUE_OCTETS = 1;
    public static final int VALUE_OID = 2;
    public static final int VALUE_UTF8 = 3;
    GeneralNames policyAuthority = null;
    Vector values = new Vector();
    int valueChoice = -1;

    public IetfAttrSyntax(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.policyAuthority = GeneralNames.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Sequence.getObjectAt(0)), (boolean)false);
            ++n;
        }
        if (!(aSN1Sequence.getObjectAt(n) instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Non-IetfAttrSyntax encoding");
        }
        aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(n);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            int n2;
            DERObject dERObject = (DERObject)enumeration.nextElement();
            if (dERObject instanceof DERObjectIdentifier) {
                n2 = 2;
            } else if (dERObject instanceof DERUniversalString) {
                n2 = 3;
            } else if (dERObject instanceof DEROctetString) {
                n2 = 1;
            } else {
                throw new IllegalArgumentException("Bad value type encoding IetfAttrSyntax");
            }
            if (this.valueChoice < 0) {
                this.valueChoice = n2;
            }
            if (n2 != this.valueChoice) {
                throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
            }
            this.values.add(dERObject);
        }
    }

    public GeneralNames getPolicyAuthority() {
        return this.policyAuthority;
    }

    public int getValueType() {
        return this.valueChoice;
    }

    public List getValues() {
        return this.values;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.policyAuthority != null) {
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)this.policyAuthority));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector2.add((DEREncodable)iterator.next());
        }
        aSN1EncodableVector.add((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector2));
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

