/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.glite.voms.contact.ProxyPolicy;

public class MyProxyCertInfo
implements DEREncodable {
    private int pathLen;
    private ProxyPolicy policy;
    private int version;

    public MyProxyCertInfo(ProxyPolicy proxyPolicy, int n) {
        this.policy = proxyPolicy;
        this.pathLen = -1;
        this.version = n;
    }

    public MyProxyCertInfo(int n, ProxyPolicy proxyPolicy, int n2) {
        this.policy = proxyPolicy;
        this.pathLen = n;
        this.version = n2;
    }

    public int getPathLenConstraint() {
        return this.pathLen;
    }

    public ProxyPolicy getProxyPolicy() {
        return this.policy;
    }

    private void setFromSeq(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 1) {
            this.pathLen = -1;
            this.policy = new ProxyPolicy((ASN1Sequence)aSN1Sequence.getObjectAt(0));
        } else {
            DEREncodable dEREncodable = aSN1Sequence.getObjectAt(0);
            if (dEREncodable instanceof DERInteger) {
                this.pathLen = ((DERInteger)dEREncodable).getValue().intValue();
                this.policy = new ProxyPolicy((ASN1Sequence)aSN1Sequence.getObjectAt(0));
                this.version = 3;
            } else {
                this.policy = new ProxyPolicy((ASN1Sequence)aSN1Sequence.getObjectAt(0));
                this.pathLen = ((DERInteger)dEREncodable).getValue().intValue();
                this.version = 4;
            }
        }
    }

    public MyProxyCertInfo(ASN1Sequence aSN1Sequence) {
        this.setFromSeq(aSN1Sequence);
    }

    public MyProxyCertInfo(byte[] byArray) {
        DERObject dERObject = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            dERObject = aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to convert byte array: " + iOException.getMessage());
        }
        if (!(dERObject instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Unable to convert byte array");
        }
        this.setFromSeq((ASN1Sequence)dERObject);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        switch (this.version) {
            case 3: {
                if (this.pathLen != -1) {
                    aSN1EncodableVector.add((DEREncodable)new DERInteger(this.pathLen));
                }
                aSN1EncodableVector.add((DEREncodable)this.policy.getDERObject());
                break;
            }
            case 4: {
                aSN1EncodableVector.add((DEREncodable)this.policy.getDERObject());
                if (this.pathLen == -1) break;
                aSN1EncodableVector.add((DEREncodable)new DERInteger(this.pathLen));
                break;
            }
        }
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

