/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.voms.PKIUtils;
import org.glite.voms.contact.VOMSException;

public class UserCredentials {
    private static final Logger log;
    private X509Certificate userCert;
    private X509Certificate[] userChain;
    private PrivateKey userKey;

    private UserCredentials(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.userKey = privateKey;
        this.userCert = x509CertificateArray[0];
        this.userChain = x509CertificateArray;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cert is: " + x509CertificateArray[0].getSubjectDN()));
            for (int i = 0; i < this.userChain.length; ++i) {
                log.debug((Object)("Chain[" + i + "] is: " + this.userChain[i].getSubjectDN()));
            }
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        PEMWriter pEMWriter = new PEMWriter((Writer)outputStreamWriter);
        log.debug((Object)("Cert is: " + this.userCert.getSubjectDN()));
        pEMWriter.writeObject((Object)this.userCert);
        if (this.userKey != null) {
            pEMWriter.writeObject((Object)this.userKey);
        }
        for (int i = 1; i < this.userChain.length; ++i) {
            log.debug((Object)("Chain[" + i + "] is: " + this.userChain[i].getSubjectDN()));
            pEMWriter.writeObject((Object)this.userChain[i]);
        }
        pEMWriter.flush();
    }

    public X509Certificate getUserCertificate() {
        return this.userCert;
    }

    public X509Certificate[] getUserChain() {
        return this.userChain;
    }

    public PrivateKey getUserKey() {
        return this.userKey;
    }

    private void loadCert(File file) {
        try {
            this.userChain = PKIUtils.loadCertificates(file);
            this.userCert = this.userChain[0];
        }
        catch (CertificateException certificateException) {
            log.debug((Object)("Error parsing user certificate: " + certificateException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)certificateException.getMessage(), (Throwable)certificateException);
            }
            throw new VOMSException(certificateException);
        }
    }

    private void loadKey(File file, String string) {
        log.debug((Object)("File is: " + file.getName()));
        this.userKey = PKIUtils.loadPrivateKey(file, (PasswordFinder)new PFinder(string));
    }

    private void loadCredentials(File file, File file2, String string) {
        this.loadCert(file);
        this.loadKey(file2, string);
    }

    private void loadPKCS12Credentials(File file, String string) {
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            fileInputStream = new FileInputStream(file);
            keyStore.load(fileInputStream, string.toCharArray());
            Enumeration<String> enumeration = keyStore.aliases();
            if (!enumeration.hasMoreElements()) {
                throw new VOMSException("No aliases found inside pkcs12 certificate!");
            }
            String string2 = enumeration.nextElement();
            this.userChain = (X509Certificate[])keyStore.getCertificateChain(string2);
            this.userCert = (X509Certificate)keyStore.getCertificate(string2);
            this.userKey = (PrivateKey)keyStore.getKey(string2, string.toCharArray());
        }
        catch (Exception exception) {
            log.error((Object)("Error importing pkcs12 certificate: " + exception.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)("Error importing pkcs12 certificate: " + exception.getMessage()), (Throwable)exception);
            }
            throw new VOMSException(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private UserCredentials(UserCredentials userCredentials) {
        this.userChain = userCredentials.getUserChain();
        this.userKey = userCredentials.getUserKey();
        this.userCert = userCredentials.getUserCertificate();
    }

    private UserCredentials(String string) {
        String string2;
        String string3;
        String string4;
        block12: {
            String string5 = System.getProperty("X509_USER_CERT", null);
            String string6 = System.getProperty("X509_USER_KEY", null);
            string4 = System.getProperty("X509_USER_KEY_PASSWORD", null);
            string3 = System.getProperty("PKCS12_USER_CERT", null);
            string2 = System.getProperty("PKCS12_USER_KEY_PASSWORD", null);
            if (string5 != null && string6 != null) {
                log.debug((Object)("Looking for pem certificates in (" + string5 + "," + string6 + ")"));
                try {
                    this.loadCredentials(new File(string5), new File(string6), string4 != null ? string4 : string);
                    log.debug((Object)"Credentials loaded succesfully.");
                    return;
                }
                catch (VOMSException vOMSException) {
                    log.debug((Object)("Error parsing credentials:" + vOMSException.getMessage()));
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Object)vOMSException.getMessage(), (Throwable)vOMSException);
                }
            }
        }
        log.debug((Object)("Looking for pem certificates in " + System.getProperty("user.home") + File.separator + ".globus"));
        File file = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.pem");
        File file2 = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "userkey.pem");
        try {
            this.loadCredentials(file, file2, string4 != null ? string4 : string);
            log.debug((Object)"Credentials loaded succesfully.");
            return;
        }
        catch (VOMSException vOMSException) {
            File file3;
            block13: {
                log.debug((Object)("Error parsing credentials:" + vOMSException.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)vOMSException.getMessage(), (Throwable)vOMSException);
                }
                if (string3 != null) {
                    log.debug((Object)("Looking for pkcs12 certificate in " + string3));
                    file3 = null;
                    try {
                        file3 = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.p12");
                        this.loadPKCS12Credentials(file3, string2 != null ? string2 : string);
                        log.debug((Object)"Credentials loaded succesfully.");
                        return;
                    }
                    catch (VOMSException vOMSException2) {
                        log.debug((Object)("Error parsing credentials from " + file3 + ":" + vOMSException2.getMessage()));
                        if (!log.isDebugEnabled()) break block13;
                        log.debug((Object)vOMSException2.getMessage(), (Throwable)vOMSException2);
                    }
                }
            }
            log.debug((Object)("Looking for pkcs12 certificate in " + System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.p12"));
            file3 = null;
            try {
                file3 = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.p12");
                this.loadPKCS12Credentials(file3, string2 != null ? string2 : string);
                log.debug((Object)"Credentials loaded succesfully.");
                return;
            }
            catch (VOMSException vOMSException3) {
                log.debug((Object)("Error parsing credentials from " + file3 + ":" + vOMSException3.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)vOMSException3.getMessage(), (Throwable)vOMSException3);
                }
                throw new VOMSException("No user credentials found!");
            }
        }
    }

    private UserCredentials(String string, String string2, String string3) {
        this.loadCredentials(new File(string), new File(string2), string3);
    }

    public static UserCredentials instance() {
        return new UserCredentials((String)null);
    }

    public static UserCredentials instance(String string) {
        return new UserCredentials(string);
    }

    public static UserCredentials instance(String string, String string2, String string3) {
        return new UserCredentials(string, string2, string3);
    }

    public static UserCredentials instance(String string, String string2) {
        return UserCredentials.instance(string, string2, null);
    }

    public static UserCredentials instance(UserCredentials userCredentials) {
        return new UserCredentials(userCredentials);
    }

    public static UserCredentials instance(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        return new UserCredentials(privateKey, x509CertificateArray);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        log = Logger.getLogger(UserCredentials.class);
    }

    private static class PFinder
    implements PasswordFinder {
        private String pwd;

        public PFinder(String string) {
            this.pwd = string;
        }

        public char[] getPassword() {
            if (this.pwd != null) {
                return this.pwd.toCharArray();
            }
            return "".toCharArray();
        }
    }
}

