/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSResponse;
import org.xml.sax.SAXException;

public class VOMSParser {
    private static Logger log = Logger.getLogger(VOMSParser.class);
    protected DocumentBuilder docBuilder;

    private VOMSParser() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        try {
            this.docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.fatal((Object)"Error configuring DOM document builder.");
            if (log.isDebugEnabled()) {
                log.debug((Object)parserConfigurationException.getMessage(), (Throwable)parserConfigurationException);
            }
            throw new VOMSException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }

    public VOMSResponse parseResponse(InputStream inputStream) {
        try {
            return new VOMSResponse(this.docBuilder.parse(inputStream));
        }
        catch (SAXException sAXException) {
            log.error((Object)("Error parsing voms server response:" + sAXException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)sAXException.getMessage(), (Throwable)sAXException);
            }
            throw new VOMSException(sAXException);
        }
        catch (IOException iOException) {
            log.error((Object)("I/O error reading voms server response:" + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw new VOMSException(iOException);
        }
    }

    public static VOMSParser instance() {
        return new VOMSParser();
    }
}

