/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.PKIVerifier;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.contact.GSIVerifier;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSESFileParser;
import org.glite.voms.contact.VOMSErrorMessage;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSParser;
import org.glite.voms.contact.VOMSProtocol;
import org.glite.voms.contact.VOMSProxyBuilder;
import org.glite.voms.contact.VOMSRequestFactory;
import org.glite.voms.contact.VOMSRequestOptions;
import org.glite.voms.contact.VOMSResponse;
import org.glite.voms.contact.VOMSServerInfo;
import org.glite.voms.contact.VOMSServerMap;
import org.glite.voms.contact.VOMSSocket;
import org.glite.voms.contact.VOMSWarningMessage;

public class VOMSProxyInit {
    private static final Logger log = Logger.getLogger(VOMSProxyInit.class);
    private static VOMSProxyInit instance;
    private VOMSServerMap serverMap;
    private UserCredentials userCredentials;
    private VOMSProtocol protocol = VOMSProtocol.instance();
    private String proxyOutputFile = File.separator + "tmp" + File.separator + "x509up_u_" + System.getProperty("user.name");
    private int proxyLifetime = 86400;
    private int proxyType = 2;
    private int delegationType = 0;
    private String policyType = null;
    private int bits = 1024;
    private VOMSWarningMessage[] warnings = null;

    public VOMSProxyInit(String string) {
        try {
            this.serverMap = VOMSESFileParser.instance().buildServerMap();
            this.userCredentials = UserCredentials.instance(string);
        }
        catch (IOException iOException) {
            log.error((Object)("Error parsing vomses files: " + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw new VOMSException(iOException);
        }
    }

    private VOMSProxyInit(UserCredentials userCredentials) {
        if (userCredentials == null) {
            throw new VOMSException("Unable to find GlobusCredentials!");
        }
        this.userCredentials = userCredentials;
        try {
            this.serverMap = VOMSESFileParser.instance().buildServerMap();
        }
        catch (IOException iOException) {
            log.error((Object)("Error parsing vomses files: " + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw new VOMSException(iOException);
        }
    }

    public static VOMSProxyInit instance(String string) {
        return new VOMSProxyInit(string);
    }

    public static VOMSProxyInit instance() {
        return new VOMSProxyInit((String)null);
    }

    public static VOMSProxyInit instance(UserCredentials userCredentials) {
        return new VOMSProxyInit(userCredentials);
    }

    public void addVomsServer(VOMSServerInfo vOMSServerInfo) {
        this.serverMap.add(vOMSServerInfo);
    }

    public synchronized AttributeCertificate getVomsAC(VOMSRequestOptions vOMSRequestOptions) {
        this.warnings = null;
        if (vOMSRequestOptions.getVoName() == null) {
            throw new VOMSException("Please specify a vo name to create a voms ac.");
        }
        Set set = this.serverMap.get(vOMSRequestOptions.getVoName());
        if (set == null) {
            throw new VOMSException("Unknown VO '" + vOMSRequestOptions.getVoName() + "'. Check the VO name or your vomses configuration files.");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            VOMSServerInfo vOMSServerInfo = (VOMSServerInfo)iterator.next();
            try {
                VOMSResponse vOMSResponse = this.contactServer(vOMSServerInfo, vOMSRequestOptions);
                if (!vOMSResponse.hasErrors()) {
                    log.debug((Object)"No errors");
                    if (vOMSResponse.hasWarnings()) {
                        this.logAndSetWarningMessages(vOMSResponse);
                    }
                    AttributeCertificate attributeCertificate = VOMSProxyBuilder.buildAC(vOMSResponse.getAC());
                    log.info((Object)("Got AC from VOMS server " + vOMSServerInfo.compactString()));
                    if (log.isDebugEnabled()) {
                        try {
                            log.debug((Object)("AC validity period:\nNotBefore:" + attributeCertificate.getNotBefore() + "\nNotAfter:" + attributeCertificate.getNotAfter()));
                        }
                        catch (ParseException parseException) {
                            log.error((Object)parseException.getMessage(), (Throwable)parseException);
                            parseException.printStackTrace();
                        }
                    }
                    return attributeCertificate;
                }
                log.error((Object)("Got error response from VOMS server " + vOMSServerInfo.compactString()));
                this.logErrorMessages(vOMSResponse);
            }
            catch (VOMSException vOMSException) {
                log.error((Object)vOMSException.getMessage());
                if (log.isDebugEnabled()) {
                    log.error((Object)vOMSException.getMessage(), (Throwable)vOMSException);
                }
                if (iterator.hasNext()) continue;
                throw vOMSException;
            }
        }
        return null;
    }

    public synchronized String getVomsData(VOMSRequestOptions vOMSRequestOptions) {
        this.warnings = null;
        if (vOMSRequestOptions.getVoName() == null) {
            throw new VOMSException("Please specify a vo name to create a voms ac.");
        }
        Set set = this.serverMap.get(vOMSRequestOptions.getVoName());
        if (set == null) {
            throw new VOMSException("Unknown VO '" + vOMSRequestOptions.getVoName() + "'. Check the VO name or your vomses configuration files.");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            VOMSServerInfo vOMSServerInfo = (VOMSServerInfo)iterator.next();
            try {
                VOMSResponse vOMSResponse = this.contactServer(vOMSServerInfo, vOMSRequestOptions);
                if (!vOMSResponse.hasErrors()) {
                    byte[] byArray;
                    if (vOMSResponse.hasWarnings()) {
                        this.logAndSetWarningMessages(vOMSResponse);
                    }
                    if ((byArray = vOMSResponse.getData()) != null) {
                        log.info((Object)("Got Data from VOMS server " + Arrays.toString(byArray)));
                        return new String(byArray);
                    }
                    if (vOMSRequestOptions.isRequestList()) {
                        AttributeCertificate attributeCertificate = VOMSProxyBuilder.buildAC(vOMSResponse.getAC());
                        if (attributeCertificate != null) {
                            List list = attributeCertificate.getFullyQualifiedAttributes();
                            StringBuilder stringBuilder = new StringBuilder();
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    stringBuilder.append((String)list.get(i));
                                    stringBuilder.append("\n");
                                }
                            }
                            return stringBuilder.toString();
                        }
                        return null;
                    }
                    return null;
                }
                log.error((Object)("Got error response from VOMS server " + vOMSServerInfo.compactString()));
                this.logErrorMessages(vOMSResponse);
            }
            catch (VOMSException vOMSException) {
                log.error((Object)vOMSException.getMessage());
                if (log.isDebugEnabled()) {
                    log.error((Object)vOMSException.getMessage(), (Throwable)vOMSException);
                }
                if (iterator.hasNext()) continue;
                throw vOMSException;
            }
        }
        return null;
    }

    public void validateACs(List list) {
        PKIVerifier pKIVerifier;
        if (list.isEmpty()) {
            throw new VOMSException("Cannot validate an empty list of Attribute Certificates!");
        }
        log.debug((Object)("AC Validation started at: " + new Date()));
        try {
            pKIVerifier = new PKIVerifier();
        }
        catch (Exception exception) {
            log.error((Object)("Error instantiating PKIVerifier: " + exception.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
            throw new VOMSException("Error instantiating PKIVerifier: " + exception.getMessage(), exception);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeCertificate attributeCertificate = (AttributeCertificate)iterator.next();
            if (pKIVerifier.verify(attributeCertificate)) continue;
            iterator.remove();
        }
        log.debug((Object)("AC Validation ended at: " + new Date()));
    }

    public synchronized UserCredentials getVomsProxy() {
        return this.getVomsProxy(null);
    }

    protected UserCredentials getGridProxy() {
        UserCredentials userCredentials = VOMSProxyBuilder.buildProxy(this.userCredentials, this.proxyLifetime, this.proxyType, this.bits);
        this.warnings = null;
        try {
            this.saveProxy(userCredentials);
            return userCredentials;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error((Object)("Error saving proxy to file " + this.proxyOutputFile + ":" + fileNotFoundException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            }
            throw new VOMSException("Error saving proxy to file " + this.proxyOutputFile + ":" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public synchronized UserCredentials getVomsProxy(Collection collection) {
        Object object;
        if (collection == null) {
            return this.getGridProxy();
        }
        if (collection.isEmpty()) {
            throw new VOMSException("No request options specified!");
        }
        Iterator iterator = collection.iterator();
        ArrayList<AttributeCertificate> arrayList = new ArrayList<AttributeCertificate>();
        this.warnings = null;
        while (iterator.hasNext()) {
            object = (VOMSRequestOptions)iterator.next();
            if (((VOMSRequestOptions)object).getVoName() == null) {
                throw new VOMSException("Please specify a vo name to create a voms proxy.");
            }
            AttributeCertificate attributeCertificate = this.getVomsAC((VOMSRequestOptions)object);
            arrayList.add(attributeCertificate);
        }
        this.validateACs(arrayList);
        if (arrayList.isEmpty()) {
            throw new VOMSException("AC validation failed!");
        }
        log.info((Object)"ACs validation succeded.");
        object = VOMSProxyBuilder.buildProxy(this.userCredentials, arrayList, this.proxyLifetime, this.proxyType, this.delegationType, this.policyType, this.bits);
        try {
            this.saveProxy((UserCredentials)object);
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error((Object)("Error saving proxy to file " + this.proxyOutputFile + ":" + fileNotFoundException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            }
            throw new VOMSException("Error saving proxy to file " + this.proxyOutputFile + ":" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    private void saveProxy(UserCredentials userCredentials) throws FileNotFoundException {
        if (this.proxyOutputFile != null) {
            VOMSProxyBuilder.saveProxy(userCredentials, this.proxyOutputFile);
            log.info((Object)("Proxy saved in :" + this.proxyOutputFile));
        }
    }

    private void logErrorMessages(VOMSResponse vOMSResponse) {
        VOMSErrorMessage[] vOMSErrorMessageArray = vOMSResponse.errorMessages();
        for (int i = 0; i < vOMSErrorMessageArray.length; ++i) {
            log.error((Object)vOMSErrorMessageArray[i]);
        }
    }

    private void logAndSetWarningMessages(VOMSResponse vOMSResponse) {
        VOMSWarningMessage[] vOMSWarningMessageArray = vOMSResponse.warningMessages();
        this.setWarnings(vOMSWarningMessageArray);
        for (int i = 0; i < vOMSWarningMessageArray.length; ++i) {
            log.warn((Object)vOMSWarningMessageArray[i]);
        }
    }

    private void setWarnings(VOMSWarningMessage[] vOMSWarningMessageArray) {
        this.warnings = vOMSWarningMessageArray;
    }

    public boolean hasWarnings() {
        return this.warnings != null;
    }

    public VOMSWarningMessage[] getWarnings() {
        return this.warnings;
    }

    private VOMSResponse contactServerREST(VOMSServerInfo vOMSServerInfo, VOMSRequestOptions vOMSRequestOptions) {
        String string = "https://" + vOMSServerInfo.getHostName() + ":" + vOMSServerInfo.getPort() + VOMSRequestFactory.instance().buildRESTRequest(vOMSRequestOptions);
        VOMSResponse vOMSResponse = null;
        log.debug((Object)("Final URL is: " + string));
        int n = vOMSServerInfo.getGlobusVersionAsInt();
        VOMSSocket vOMSSocket = n > 0 ? VOMSSocket.instance(this.userCredentials, vOMSServerInfo.getHostDn(), n) : VOMSSocket.instance(this.userCredentials, vOMSServerInfo.getHostDn());
        HttpsURLConnection httpsURLConnection = null;
        try {
            SSLSocketFactory sSLSocketFactory = vOMSSocket.getFactory();
            URL uRL = new URL(string);
            httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
            HostnameVerifier hostnameVerifier = httpsURLConnection.getDefaultHostnameVerifier();
            httpsURLConnection.setHostnameVerifier(new GSIVerifier(hostnameVerifier, vOMSServerInfo.getHostDn()));
            httpsURLConnection.connect();
            Object object = httpsURLConnection.getContent();
            vOMSResponse = VOMSParser.instance().parseResponse((InputStream)object);
        }
        catch (Exception exception) {
            log.error((Object)("Error connecting to " + vOMSServerInfo.compactString() + ":" + exception.getMessage()));
            try {
                log.error((Object)("Error code is: " + httpsURLConnection.getResponseCode()));
                InputStream inputStream = httpsURLConnection.getErrorStream();
                vOMSResponse = VOMSParser.instance().parseResponse(inputStream);
                return vOMSResponse;
            }
            catch (Exception exception2) {
                if (log.isDebugEnabled()) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
                throw new VOMSException("Error connecting to " + vOMSServerInfo.compactString() + ":" + exception2.getMessage(), exception2);
            }
        }
        return vOMSResponse;
    }

    protected VOMSResponse contactServer(VOMSServerInfo vOMSServerInfo, VOMSRequestOptions vOMSRequestOptions) {
        VOMSResponse vOMSResponse;
        log.info((Object)("Contacting server " + vOMSServerInfo.compactString()));
        VOMSResponse vOMSResponse2 = this.contactServerREST(vOMSServerInfo, vOMSRequestOptions);
        if (vOMSResponse2 != null) {
            return vOMSResponse2;
        }
        int n = vOMSServerInfo.getGlobusVersionAsInt();
        VOMSSocket vOMSSocket = n > 0 ? VOMSSocket.instance(this.userCredentials, vOMSServerInfo.getHostDn(), n) : VOMSSocket.instance(this.userCredentials, vOMSServerInfo.getHostDn());
        try {
            vOMSSocket.connect(vOMSServerInfo.getHostName(), vOMSServerInfo.getPort());
        }
        catch (Exception exception) {
            log.error((Object)("Error connecting to " + vOMSServerInfo.compactString() + ":" + exception.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
            throw new VOMSException("Error connecting to " + vOMSServerInfo.compactString() + ":" + exception.getMessage(), exception);
        }
        try {
            vOMSRequestOptions.setVoName(vOMSServerInfo.getVoName());
            this.protocol.sendRequest(vOMSRequestOptions, vOMSSocket.getOutputStream());
            vOMSResponse = this.protocol.getResponse(vOMSSocket.getInputStream());
            vOMSSocket.close();
        }
        catch (IOException iOException) {
            log.error((Object)("Error communicating with server " + vOMSServerInfo.getHostName() + ":" + vOMSServerInfo.getPort() + ":" + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw new VOMSException("Error communicating with server " + vOMSServerInfo.getHostName() + ":" + vOMSServerInfo.getPort() + ":" + iOException.getMessage(), iOException);
        }
        return vOMSResponse;
    }

    public String getProxyOutputFile() {
        return this.proxyOutputFile;
    }

    public void setProxyOutputFile(String string) {
        this.proxyOutputFile = string;
    }

    public int getProxyLifetime() {
        return this.proxyLifetime;
    }

    public void setProxyLifetime(int n) {
        this.proxyLifetime = n;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(int n) {
        this.proxyType = n;
    }

    public int getProxyKeySize() {
        return this.bits;
    }

    public void setProxyKeySize(int n) {
        this.bits = n;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String string) {
        this.policyType = string;
    }

    public int getDelegationType() {
        return this.delegationType;
    }

    public void setDelegationType(int n) {
        this.delegationType = n;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

