/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.glite.voms.contact.VOMSServerInfo;

public class VOMSServerMap {
    protected Map map = new TreeMap();

    public void add(VOMSServerInfo vOMSServerInfo) {
        String string = vOMSServerInfo.getAlias();
        if (this.map.containsKey(string)) {
            Set set = (Set)this.map.get(string);
            set.add(vOMSServerInfo);
            return;
        }
        HashSet<VOMSServerInfo> hashSet = new HashSet<VOMSServerInfo>();
        hashSet.add(vOMSServerInfo);
        this.map.put(string, hashSet);
    }

    public Set get(String string) {
        return (Set)this.map.get(string);
    }

    public int serverCount(String string) {
        if (this.map.containsKey(string)) {
            return ((Set)this.map.get(string)).size();
        }
        return 0;
    }

    public void merge(VOMSServerMap vOMSServerMap) {
        for (Map.Entry entry : vOMSServerMap.map.entrySet()) {
            if (this.map.containsKey(entry.getKey())) {
                this.get((String)entry.getKey()).addAll((Set)entry.getValue());
                continue;
            }
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        if (this.map == null || this.map.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.map.entrySet().iterator();
        stringBuilder.append("VOMSServerMap:[\n");
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuilder.append(entry.getKey() + ":\n");
            stringBuilder.append("\tnum_servers: " + ((Set)entry.getValue()).size() + "\n");
            stringBuilder.append("\tserver_details: \n\t\t" + StringUtils.join(((Set)entry.getValue()).iterator(), (String)"\n\t\t") + "\n");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }
}

