/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.NarayanaTransactionIntegration;
import io.agroal.springframework.boot.AgroalDataSource;
import javax.sql.DataSource;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AgroalDataSource.class})
@ConditionalOnMissingBean(value={DataSource.class})
@ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="io.agroal.springframework.boot.AgroalDataSource", matchIfMissing=true)
public class AgroalDataSourceConfiguration {
    @Autowired(required=false)
    public JtaTransactionManager jtaPlatform;
    @Autowired(required=false)
    public XAResourceRecoveryRegistry recoveryRegistry;

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.agroal")
    public AgroalDataSource dataSource(DataSourceProperties properties, @Value(value="${spring.datasource.agroal.connectable:false}") boolean connectable) {
        AgroalDataSource dataSource = (AgroalDataSource)((Object)properties.initializeDataSourceBuilder().type(AgroalDataSource.class).build());
        if (!StringUtils.hasLength((String)properties.getDriverClassName())) {
            DatabaseDriver driver = DatabaseDriver.fromJdbcUrl((String)properties.determineUrl());
            if (connectable) {
                dataSource.setDriverClassName(driver.getDriverClassName());
            } else {
                dataSource.setDriverClassName(driver.getXaDataSourceClassName());
            }
        }
        String name = properties.determineDatabaseName();
        dataSource.setName(name);
        if (this.jtaPlatform != null && this.jtaPlatform.getTransactionManager() != null && this.jtaPlatform.getTransactionSynchronizationRegistry() != null) {
            NarayanaTransactionIntegration transactionIntegration = new NarayanaTransactionIntegration(this.jtaPlatform.getTransactionManager(), this.jtaPlatform.getTransactionSynchronizationRegistry(), name, connectable, this.recoveryRegistry);
            dataSource.setJtaTransactionIntegration((TransactionIntegration)transactionIntegration);
        }
        return dataSource;
    }
}

