/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.DeleteResourceCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DeleteResourceResponse;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.DeleteResourceResponseImpl;
import io.camunda.client.protocol.rest.DeleteResourceRequest;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public class DeleteResourceCommandImpl
implements DeleteResourceCommandStep1 {
    private final GatewayOuterClass.DeleteResourceRequest.Builder requestBuilder = GatewayOuterClass.DeleteResourceRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final DeleteResourceRequest httpRequestObject;
    private boolean useRest;
    private final long resourceKey;
    private final JsonMapper jsonMapper;

    public DeleteResourceCommandImpl(long resourceKey, GatewayGrpc.GatewayStub asyncStub, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, CamundaClientConfiguration config, JsonMapper jsonMapper) {
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.requestBuilder.setResourceKey(resourceKey);
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new DeleteResourceRequest();
        this.useRest = config.preferRestOverGrpc();
        this.resourceKey = resourceKey;
        this.jsonMapper = jsonMapper;
        this.requestTimeout(this.requestTimeout);
    }

    @Override
    public FinalCommandStep<DeleteResourceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DeleteResourceResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private CamundaFuture<DeleteResourceResponse> sendRestRequest() {
        HttpCamundaFuture<DeleteResourceResponse> result = new HttpCamundaFuture<DeleteResourceResponse>();
        this.httpClient.post("/resources/" + this.resourceKey + "/deletion", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), DeleteResourceResponseImpl::new, result);
        return result;
    }

    private CamundaFuture<DeleteResourceResponse> sendGrpcRequest() {
        GatewayOuterClass.DeleteResourceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<DeleteResourceResponse, GatewayOuterClass.DeleteResourceResponse> future = new RetriableClientFutureImpl<DeleteResourceResponse, GatewayOuterClass.DeleteResourceResponse>(DeleteResourceResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.DeleteResourceResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.DeleteResourceResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.DeleteResourceRequest request, StreamObserver<GatewayOuterClass.DeleteResourceResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).deleteResource(request, streamObserver);
    }

    @Override
    public DeleteResourceCommandStep1 operationReference(long operationReference) {
        this.requestBuilder.setOperationReference(operationReference);
        this.httpRequestObject.setOperationReference(operationReference);
        return this;
    }

    @Override
    public DeleteResourceCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public DeleteResourceCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

