/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.filter;

import io.camunda.client.api.search.filter.VariableValueFilter;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.protocol.rest.StringFilterProperty;
import io.camunda.client.protocol.rest.VariableValueFilterProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VariableFilterMapper {
    public static List<VariableValueFilterProperty> toVariableValueFilterProperty(List<Consumer<VariableValueFilter>> variableValueFilters) {
        return VariableFilterMapper.toVariableValueFilterProperty(variableValueFilters.stream().map(SearchRequestBuilders::variableValueFilter).map(TypedSearchRequestPropertyProvider::provideSearchRequestProperty));
    }

    public static List<VariableValueFilterProperty> toVariableValueFilterProperty(Map<String, Object> variableValueFilters) {
        return VariableFilterMapper.toVariableValueFilterProperty(variableValueFilters.entrySet().stream().map(entry -> new VariableValueFilterProperty().name((String)entry.getKey()).value(entry.getValue() == null ? new StringFilterProperty() : new StringFilterProperty().$eq(entry.getValue().toString()))));
    }

    static List<VariableValueFilterProperty> toVariableValueFilterProperty(Stream<VariableValueFilterProperty> filterStream) {
        ArrayList violations = new ArrayList();
        List<VariableValueFilterProperty> filters = filterStream.map(filter -> VariableFilterMapper.checkVariableValueNotNull(filter, violations)).collect(Collectors.toList());
        if (!violations.isEmpty()) {
            throw new IllegalArgumentException("Variable value filters contain violations: " + String.join((CharSequence)". ", violations));
        }
        return filters;
    }

    static VariableValueFilterProperty checkVariableValueNotNull(VariableValueFilterProperty filter, List<String> violations) {
        if (filter.getValue() == null || filter.getValue().equals(new StringFilterProperty())) {
            violations.add("Variable value cannot be null for variable '" + filter.getName() + "'");
        }
        return filter;
    }
}

