/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.fetch.AuthorizationsSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Authorization;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.AuthorizationSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.AuthorizationFilter;
import io.camunda.client.protocol.rest.AuthorizationSearchQuery;
import io.camunda.client.protocol.rest.AuthorizationSearchResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class AuthorizationsSearchRequestImpl
extends TypedSearchRequestPropertyProvider<AuthorizationSearchQuery>
implements AuthorizationsSearchRequest {
    private final AuthorizationSearchQuery request;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;

    public AuthorizationsSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new AuthorizationSearchQuery();
    }

    @Override
    public FinalSearchRequestStep<Authorization> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Authorization>> send() {
        HttpCamundaFuture<SearchResponse<Authorization>> result = new HttpCamundaFuture<SearchResponse<Authorization>>();
        this.httpClient.post("/authorizations/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), AuthorizationSearchResult.class, SearchResponseMapper::toAuthorizationsResponse, result);
        return result;
    }

    @Override
    public AuthorizationsSearchRequest filter(io.camunda.client.api.search.filter.AuthorizationFilter value) {
        this.request.setFilter((AuthorizationFilter)AuthorizationsSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public AuthorizationsSearchRequest filter(Consumer<io.camunda.client.api.search.filter.AuthorizationFilter> fn) {
        return this.filter(SearchRequestBuilders.authorizationFilter(fn));
    }

    @Override
    public AuthorizationsSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)AuthorizationsSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public AuthorizationsSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public AuthorizationsSearchRequest sort(AuthorizationSort value) {
        this.request.setSort(SearchRequestSortMapper.toAuthorizationSearchQuerySortRequest((List)AuthorizationsSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public AuthorizationsSearchRequest sort(Consumer<AuthorizationSort> fn) {
        return this.sort(SearchRequestBuilders.authorizationSort(fn));
    }

    @Override
    protected AuthorizationSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

