/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.ClientFilter;
import io.camunda.client.api.search.request.ClientsByTenantSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Client;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.ClientSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.TenantClientSearchQueryRequest;
import io.camunda.client.protocol.rest.TenantClientSearchResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ClientsByTenantSearchRequestImpl
extends TypedSearchRequestPropertyProvider<TenantClientSearchQueryRequest>
implements ClientsByTenantSearchRequest {
    private final TenantClientSearchQueryRequest request;
    private final String tenantId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public ClientsByTenantSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String tenantId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.tenantId = tenantId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new TenantClientSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Client> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Client>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("tenantId", this.tenantId);
        HttpCamundaFuture<SearchResponse<Client>> result = new HttpCamundaFuture<SearchResponse<Client>>();
        this.httpClient.post(String.format("/tenants/%s/clients/search", this.tenantId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), TenantClientSearchResult.class, SearchResponseMapper::toTenantClientsResponse, result);
        return result;
    }

    @Override
    public ClientsByTenantSearchRequest filter(ClientFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public ClientsByTenantSearchRequest filter(Consumer<ClientFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public ClientsByTenantSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)ClientsByTenantSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ClientsByTenantSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public ClientsByTenantSearchRequest sort(ClientSort value) {
        this.request.setSort(SearchRequestSortMapper.toTenantClientSearchQuerySortRequest((List)ClientsByTenantSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public ClientsByTenantSearchRequest sort(Consumer<ClientSort> fn) {
        return this.sort(SearchRequestBuilders.clientSort(fn));
    }

    @Override
    protected TenantClientSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

