/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.response.CorrelatedMessageSubscription;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.CorrelatedMessageSubscriptionResult;
import java.time.OffsetDateTime;
import java.util.Objects;

public class CorrelatedMessageSubscriptionImpl
implements CorrelatedMessageSubscription {
    private final String correlationKey;
    private final OffsetDateTime correlationTime;
    private final String elementId;
    private final Long elementInstanceKey;
    private final Long messageKey;
    private final String messageName;
    private final Integer partitionId;
    private final String processDefinitionId;
    private final Long processDefinitionKey;
    private final Long processInstanceKey;
    private final Long subscriptionKey;
    private final String tenantId;

    public CorrelatedMessageSubscriptionImpl(CorrelatedMessageSubscriptionResult item) {
        this.correlationKey = item.getCorrelationKey();
        this.correlationTime = ParseUtil.parseOffsetDateTimeOrNull(item.getCorrelationTime());
        this.elementId = item.getElementId();
        this.elementInstanceKey = ParseUtil.parseLongOrNull(item.getElementInstanceKey());
        this.messageKey = ParseUtil.parseLongOrNull(item.getMessageKey());
        this.messageName = item.getMessageName();
        this.partitionId = item.getPartitionId();
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
        this.subscriptionKey = ParseUtil.parseLongOrNull(item.getSubscriptionKey());
        this.tenantId = item.getTenantId();
    }

    @Override
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    @Override
    public OffsetDateTime getCorrelationTime() {
        return this.correlationTime;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public Long getMessageKey() {
        return this.messageKey;
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public Integer getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public Long getSubscriptionKey() {
        return this.subscriptionKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(this.correlationKey, this.correlationTime, this.elementId, this.elementInstanceKey, this.messageKey, this.messageName, this.partitionId, this.processDefinitionId, this.processDefinitionKey, this.processInstanceKey, this.subscriptionKey, this.tenantId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrelatedMessageSubscriptionImpl correlatedMessageSubscription = (CorrelatedMessageSubscriptionImpl)o;
        return Objects.equals(this.correlationKey, correlatedMessageSubscription.correlationKey) && Objects.equals(this.correlationTime, correlatedMessageSubscription.correlationTime) && Objects.equals(this.elementId, correlatedMessageSubscription.elementId) && Objects.equals(this.elementInstanceKey, correlatedMessageSubscription.elementInstanceKey) && Objects.equals(this.messageKey, correlatedMessageSubscription.messageKey) && Objects.equals(this.messageName, correlatedMessageSubscription.messageName) && Objects.equals(this.partitionId, correlatedMessageSubscription.partitionId) && Objects.equals(this.processDefinitionId, correlatedMessageSubscription.processDefinitionId) && Objects.equals(this.processDefinitionKey, correlatedMessageSubscription.processDefinitionKey) && Objects.equals(this.processInstanceKey, correlatedMessageSubscription.processInstanceKey) && Objects.equals(this.subscriptionKey, correlatedMessageSubscription.subscriptionKey) && Objects.equals(this.tenantId, correlatedMessageSubscription.tenantId);
    }
}

