/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.util;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnumUtil {
    private static final String UNKNOWN_ENUM_VALUE = "UNKNOWN_ENUM_VALUE";
    private static final String UNKNOWN_DEFAULT_OPEN_API = "UNKNOWN_DEFAULT_OPEN_API";
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumUtil.class);

    private EnumUtil() {
    }

    public static <E> void logUnknownEnumValue(Object value, String enumName, E[] validValues) {
        LOGGER.debug("Unexpected {} '{}', should be one of {}", new Object[]{enumName, value, Arrays.toString(validValues)});
    }

    public static <E1 extends Enum<E1>, E2 extends Enum<E2>> E2 convert(E1 source, Class<E2> targetClass) {
        if (source == null) {
            return null;
        }
        try {
            if (source.name().equals(UNKNOWN_ENUM_VALUE)) {
                return Enum.valueOf(targetClass, UNKNOWN_DEFAULT_OPEN_API);
            }
            if (source.name().equals(UNKNOWN_DEFAULT_OPEN_API)) {
                return Enum.valueOf(targetClass, UNKNOWN_ENUM_VALUE);
            }
            return Enum.valueOf(targetClass, source.name());
        }
        catch (IllegalArgumentException e) {
            EnumUtil.logUnknownEnumValue(source, source.getClass().getName(), (Enum[])targetClass.getEnumConstants());
            throw new RuntimeException(e);
        }
    }
}

