/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling;

import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.worker.BackoffSupplier;
import io.camunda.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.client.metrics.MetricsRecorder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CommandWrapper {
    private final FinalCommandStep<?> command;
    private final ActivatedJob job;
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;
    private long currentRetryDelay = 50L;
    private int invocationCounter = 0;
    private final int maxRetries;

    public CommandWrapper(FinalCommandStep<?> command, ActivatedJob job, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, int maxRetries) {
        this.command = command;
        this.job = job;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.metricsRecorder = metricsRecorder;
        this.maxRetries = maxRetries;
    }

    public void executeAsync() {
        ++this.invocationCounter;
        this.command.send().exceptionally(t -> {
            this.commandExceptionHandlingStrategy.handleCommandError(this, (Throwable)t);
            return null;
        });
    }

    public void executeAsyncWithMetrics(String metricName, String action, String type) {
        ++this.invocationCounter;
        this.command.send().thenApply(result -> {
            this.metricsRecorder.increase(metricName, action, type);
            return result;
        }).exceptionally(t -> {
            this.commandExceptionHandlingStrategy.handleCommandError(this, (Throwable)t);
            return null;
        });
    }

    public void increaseBackoffUsing(BackoffSupplier backoffSupplier) {
        this.currentRetryDelay = backoffSupplier.supplyRetryDelay(this.currentRetryDelay);
    }

    public void scheduleExecutionUsing(ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.schedule(this::executeAsync, this.currentRetryDelay, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "{command=" + String.valueOf(this.command.getClass()) + ", job=" + String.valueOf(this.job) + ", currentRetryDelay=" + this.currentRetryDelay + "}";
    }

    public boolean hasMoreRetries() {
        if (this.jobDeadlineExceeded()) {
            return false;
        }
        return this.invocationCounter < this.maxRetries;
    }

    private boolean jobDeadlineExceeded() {
        return System.currentTimeMillis() > this.job.getDeadline();
    }
}

