/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling;

import io.camunda.client.CamundaClient;
import io.camunda.client.annotation.value.JobWorkerValue;
import io.camunda.client.api.worker.BackoffSupplier;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.client.api.worker.JobWorker;
import io.camunda.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.client.api.worker.JobWorkerMetrics;
import io.camunda.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.client.jobhandling.JobExceptionHandlingStrategy;
import io.camunda.client.jobhandling.JobHandlerInvokingBeans;
import io.camunda.client.jobhandling.JobHandlingUtil;
import io.camunda.client.jobhandling.parameter.ParameterResolver;
import io.camunda.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.client.jobhandling.result.ResultProcessor;
import io.camunda.client.jobhandling.result.ResultProcessorStrategy;
import io.camunda.client.metrics.CamundaClientMetricsBridge;
import io.camunda.client.metrics.MetricsRecorder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorkerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerManager.class);
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;
    private final ParameterResolverStrategy parameterResolverStrategy;
    private final ResultProcessorStrategy resultProcessorStrategy;
    private final BackoffSupplier backoffSupplier;
    private final JobExceptionHandlingStrategy jobExceptionHandlingStrategy;
    private List<JobWorker> openedWorkers = new ArrayList<JobWorker>();
    private final List<JobWorkerValue> workerValues = new ArrayList<JobWorkerValue>();

    public JobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy, ResultProcessorStrategy resultProcessorStrategy, BackoffSupplier backoffSupplier, JobExceptionHandlingStrategy jobExceptionHandlingStrategy) {
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.metricsRecorder = metricsRecorder;
        this.parameterResolverStrategy = parameterResolverStrategy;
        this.resultProcessorStrategy = resultProcessorStrategy;
        this.backoffSupplier = backoffSupplier;
        this.jobExceptionHandlingStrategy = jobExceptionHandlingStrategy;
    }

    public JobWorker openWorker(CamundaClient client, JobWorkerValue jobWorkerValue) {
        List<ParameterResolver> parameterResolvers = JobHandlingUtil.createParameterResolvers(this.parameterResolverStrategy, jobWorkerValue);
        ResultProcessor resultProcessor = JobHandlingUtil.createResultProcessor(this.resultProcessorStrategy, jobWorkerValue);
        return this.openWorker(client, jobWorkerValue, new JobHandlerInvokingBeans(jobWorkerValue, this.commandExceptionHandlingStrategy, this.metricsRecorder, parameterResolvers, resultProcessor, this.jobExceptionHandlingStrategy));
    }

    public JobWorker openWorker(CamundaClient client, JobWorkerValue jobWorkerValue, JobHandler handler) {
        JobWorkerBuilderStep1.JobWorkerBuilderStep3 builder = client.newWorker().jobType(jobWorkerValue.getType()).handler(handler).name(jobWorkerValue.getName()).backoffSupplier(this.backoffSupplier).metrics((JobWorkerMetrics)new CamundaClientMetricsBridge(this.metricsRecorder, jobWorkerValue.getType()));
        if (jobWorkerValue.getMaxJobsActive() != null && jobWorkerValue.getMaxJobsActive() > 0) {
            builder.maxJobsActive(jobWorkerValue.getMaxJobsActive().intValue());
        }
        if (this.isValidDuration(jobWorkerValue.getTimeout())) {
            builder.timeout(jobWorkerValue.getTimeout());
        }
        if (this.isValidDuration(jobWorkerValue.getPollInterval())) {
            builder.pollInterval(jobWorkerValue.getPollInterval());
        }
        if (this.isValidDuration(jobWorkerValue.getRequestTimeout())) {
            builder.requestTimeout(jobWorkerValue.getRequestTimeout());
        }
        if (jobWorkerValue.getFetchVariables() != null && !jobWorkerValue.getFetchVariables().isEmpty()) {
            builder.fetchVariables(jobWorkerValue.getFetchVariables());
        }
        if (jobWorkerValue.getTenantIds() != null && !jobWorkerValue.getTenantIds().isEmpty()) {
            builder.tenantIds(jobWorkerValue.getTenantIds());
        }
        if (jobWorkerValue.getStreamEnabled() != null) {
            builder.streamEnabled(jobWorkerValue.getStreamEnabled().booleanValue());
        }
        if (this.isValidDuration(jobWorkerValue.getStreamTimeout())) {
            builder.streamTimeout(jobWorkerValue.getStreamTimeout());
        }
        JobWorker jobWorker = builder.open();
        this.openedWorkers.add(jobWorker);
        this.workerValues.add(jobWorkerValue);
        LOGGER.info(". Starting job worker: {}", (Object)jobWorkerValue);
        return jobWorker;
    }

    private boolean isValidDuration(Duration duration) {
        return duration != null && !duration.isNegative();
    }

    public void closeAllOpenWorkers() {
        this.openedWorkers.forEach(worker -> worker.close());
        this.openedWorkers = new ArrayList<JobWorker>();
    }

    public void closeWorker(JobWorker worker) {
        worker.close();
        int i = this.openedWorkers.indexOf(worker);
        this.openedWorkers.remove(i);
        this.workerValues.remove(i);
    }

    public Optional<JobWorkerValue> findJobWorkerConfigByName(String name) {
        return this.workerValues.stream().filter(worker -> worker.getName().equals(name)).findFirst();
    }

    public Optional<JobWorkerValue> findJobWorkerConfigByType(String type) {
        return this.workerValues.stream().filter(worker -> worker.getType().equals(type)).findFirst();
    }
}

