/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.annotation.processor;

import io.camunda.client.CamundaClient;
import io.camunda.client.bean.BeanInfo;
import io.camunda.client.lifecycle.CamundaClientLifecycleAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;

public abstract class AbstractCamundaAnnotationProcessor
implements ApplicationContextAware,
CamundaClientLifecycleAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected abstract boolean isApplicableFor(BeanInfo var1);

    protected abstract void configureFor(BeanInfo var1);

    protected abstract void start(CamundaClient var1);

    protected abstract void stop(CamundaClient var1);

    @Override
    public void onStart(CamundaClient client) {
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            BeanInfo beanInfo;
            Class beanType = this.applicationContext.getType(beanName, false);
            if (beanType == null || !this.isApplicableFor(beanInfo = BeanInfo.builder().beanName(beanName).targetClass(ClassUtils.getUserClass((Class)beanType)).beanSupplier(() -> this.applicationContext.getBean(beanName)).build())) continue;
            this.configureFor(beanInfo);
        }
        this.start(client);
    }

    @Override
    public void onStop(CamundaClient client) {
        this.stop(client);
    }
}

