/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.authorizations.dto;

import java.util.Set;

public class UpdateAuthorizations {
  final String entityId;
  final String entityType;
  final String organizationId;
  final String resourceKey;
  final String resourceType;
  final Set<String> permissions;

  public UpdateAuthorizations(
      final String entityId,
      final String entityType,
      final String organizationId,
      final String resourceKey,
      final String resourceType,
      final Set<String> permissions
  ) {
    this.entityId = entityId;
    this.entityType = entityType;
    this.organizationId = organizationId;
    this.resourceKey = resourceKey;
    this.resourceType = resourceType;
    this.permissions = permissions;
  }

  public String getEntityId() {
    return entityId;
  }

  public String getEntityType() {
    return entityType;
  }

  public String getOrganizationId() {
    return organizationId;
  }

  public String getResourceKey() {
    return resourceKey;
  }

  public String getResourceType() {
    return resourceType;
  }

  public Set<String> getPermissions() {
    return permissions;
  }
}
