/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"tenantId", "signalKey"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SignalBroadcastResult {
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    @Nullable
    private String tenantId;
    public static final String JSON_PROPERTY_SIGNAL_KEY = "signalKey";
    @Nullable
    private String signalKey;

    public SignalBroadcastResult tenantId(@Nullable String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(@Nullable String tenantId) {
        this.tenantId = tenantId;
    }

    public SignalBroadcastResult signalKey(@Nullable String signalKey) {
        this.signalKey = signalKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="signalKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignalKey() {
        return this.signalKey;
    }

    @JsonProperty(value="signalKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignalKey(@Nullable String signalKey) {
        this.signalKey = signalKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalBroadcastResult signalBroadcastResult = (SignalBroadcastResult)o;
        return Objects.equals(this.tenantId, signalBroadcastResult.tenantId) && Objects.equals(this.signalKey, signalBroadcastResult.signalKey);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.signalKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalBroadcastResult {\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    signalKey: ").append(this.toIndentedString(this.signalKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSignalKey() != null) {
            try {
                joiner.add(String.format("%ssignalKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSignalKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

