/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.onc.rpc;

import com.sun.jndi.internal.onc.rpc.dgpkt;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

class ReadThread
implements Runnable {
    private static final int INBUFSZ = 9000;
    protected static boolean trace = false;
    private Object waiting;
    private byte[] inbuffer;
    private byte[] inbuf;
    private boolean hangup = false;
    private IOException read_exception = null;
    private Object read_lock = new Object();
    private boolean producer_waiting = false;
    private boolean consumer_waiting = false;
    private DatagramSocket iso;
    private DatagramPacket iso_pkt;
    private InetAddress last_address;
    private int last_port;

    ReadThread(Object object, DatagramSocket datagramSocket) {
        this.waiting = object;
        this.inbuffer = null;
        this.iso = datagramSocket;
        this.inbuf = new byte[9000];
        this.iso_pkt = new DatagramPacket(this.inbuf, this.inbuf.length);
    }

    public synchronized void closeit() {
        if (trace) {
            System.err.println(String.valueOf(this.getClass().getName()) + ".closeit: call");
        }
        this.hangup = true;
        Object object = this.read_lock;
        synchronized (object) {
            if (this.producer_waiting) {
                if (trace) {
                    System.err.println(String.valueOf(this.getClass().getName()) + ".close: notify producer");
                }
                this.read_lock.notify();
            }
        }
        this.do_hangup();
    }

    private synchronized void do_hangup() {
        if (trace) {
            System.err.println(String.valueOf(this.getClass().getName()) + ".do_hangup: closing fd");
        }
        if (this.iso != null) {
            this.iso.close();
            this.iso = null;
        }
        Object object = this.read_lock;
        synchronized (object) {
            if (this.consumer_waiting) {
                if (trace) {
                    System.err.println("NOTIFY consumer (from do_hangup)");
                }
                this.read_lock.notify();
            }
        }
    }

    public byte[] get_or_wait(long l) throws IOException {
        dgpkt dgpkt2 = this.get_or_wait_pkt(l);
        return dgpkt2.data;
    }

    public dgpkt get_or_wait_pkt(long l) throws IOException {
        Object object = this.read_lock;
        synchronized (object) {
            block13: {
                if (this.producer_waiting) {
                    if (trace) {
                        System.err.println("NOTIFY reader (producer) by consumer");
                    }
                    this.read_lock.notify();
                }
                this.consumer_waiting = true;
                try {
                    if (trace) {
                        System.err.println("WAIT on read_lock (producer) by consumer -- wait for data");
                    }
                    this.read_lock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    if (!trace) break block13;
                    System.err.println("WAIT interrupted (consumer)");
                }
            }
            if (trace) {
                System.err.println("WAIT complete (consumer)");
            }
            this.consumer_waiting = false;
        }
        if (this.read_exception != null) {
            throw this.read_exception;
        }
        ReadThread readThread = this;
        synchronized (readThread) {
            dgpkt dgpkt2 = new dgpkt();
            dgpkt2.data = this.inbuffer;
            dgpkt2.src_ip = this.last_address;
            dgpkt2.src_port = this.last_port;
            this.inbuffer = null;
            object = dgpkt2;
            Object var5_5 = null;
            return object;
        }
    }

    public void run() {
        int n = 0;
        if (trace) {
            System.err.println(String.valueOf(this.getClass().getName()) + ".run: call");
        }
        while (!this.hangup) {
            Object object = this.read_lock;
            synchronized (object) {
                if (!this.consumer_waiting) {
                    this.producer_waiting = true;
                    try {
                        if (trace) {
                            System.err.println("WAIT on read_lock (producer) -- no consumer");
                        }
                        this.read_lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.producer_waiting = false;
                        this.do_hangup();
                        Object var4_8 = null;
                        break;
                    }
                    this.producer_waiting = false;
                }
            }
            object = this;
            synchronized (object) {
                if (this.hangup) {
                    this.do_hangup();
                    Object var4_9 = null;
                    break;
                }
            }
            try {
                if (this.iso != null) {
                    this.iso_pkt.setLength(this.inbuf.length);
                    this.iso.receive(this.iso_pkt);
                    n = this.iso_pkt.getLength();
                }
            }
            catch (IOException iOException) {
                if (trace) {
                    System.err.println(String.valueOf(this.getClass().getName()) + ".run: read error");
                    iOException.printStackTrace();
                }
                ReadThread readThread = this;
                synchronized (readThread) {
                    this.read_exception = iOException;
                    n = 0;
                    this.do_hangup();
                    Object var5_12 = null;
                    break;
                }
            }
            if (trace) {
                System.err.println(String.valueOf(this.getClass().getName()) + ".run: read " + n + " bytes");
            }
            object = this;
            synchronized (object) {
                if (this.hangup) {
                    this.do_hangup();
                    Object var4_11 = null;
                    break;
                }
            }
            if (n < 0) {
                if (trace) {
                    System.err.println(String.valueOf(this.getClass().getName()) + ".run: read EOF");
                }
                this.do_hangup();
                break;
            }
            if (n == 0) {
                if (trace) {
                    System.err.println(String.valueOf(this.getClass().getName()) + ".run: read 0 bytes");
                }
                this.do_hangup();
                break;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.inbuf, 0, byArray, 0, byArray.length);
            if (trace) {
                System.err.print(String.valueOf(this.getClass().getName()) + ".run: ");
                System.err.println(String.valueOf(byArray.length) + " data bytes:");
                int n2 = 0;
                while (n2 < n) {
                    int n3 = byArray[n2] & 0xFF;
                    System.err.print(String.valueOf(n3) + " ");
                    ++n2;
                }
                System.err.println();
            }
            object = this;
            synchronized (object) {
                this.inbuffer = byArray;
                if (this.iso != null) {
                    this.last_address = this.iso_pkt.getAddress();
                    this.last_port = this.iso_pkt.getPort();
                } else {
                    this.last_address = null;
                    this.last_port = 0;
                }
            }
            object = this.read_lock;
            synchronized (object) {
                if (trace) {
                    System.err.println("NOTIFY read_lock (consumer) by producer -- data read");
                }
                this.read_lock.notify();
            }
        }
    }
}

