/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.onc.rpc;

import com.sun.jndi.internal.onc.rpc.HardErrorException;
import com.sun.jndi.internal.onc.rpc.MsgDeniedException;
import com.sun.jndi.internal.onc.rpc.authsys_params;
import com.sun.jndi.internal.onc.rpc.call_body;
import com.sun.jndi.internal.onc.rpc.msg_type;
import com.sun.jndi.internal.onc.rpc.opaque_auth;
import com.sun.jndi.internal.onc.rpc.reply_body_u;
import com.sun.jndi.internal.onc.rpc.rpc_msg;
import com.sun.jndi.internal.onc.rpc.rpc_msg_u;
import com.sun.jndi.internal.onc.rpc.xdr_basic;
import com.sun.jndi.internal.onc.rpc.xdrin_upcall;
import com.sun.jndi.internal.onc.rpc.xdrout_upcall;
import java.io.IOException;

public abstract class rpc_client {
    static final int RPC_MSG_VERSION = 2;
    static boolean trace = false;
    static boolean trace_close = false;
    private boolean close_called = false;
    protected rpc_msg call_msg = null;
    protected opaque_auth cred;
    protected opaque_auth verf;
    protected int security;
    private boolean my_xdrs;
    protected xdr_basic xdrs;
    private static long xid_seed;

    static {
        long l = System.currentTimeMillis();
        xid_seed = l | l * 1000L;
    }

    protected rpc_client(int n) throws IOException {
        switch (n) {
            case 0: {
                this.cred = new opaque_auth(0);
                this.verf = new opaque_auth(0);
                break;
            }
            case 1: {
                this.cred = new opaque_auth(1);
                this.cred.auth = xdr_basic.xdrmem_xdrbytes(new authsys_params());
                this.verf = new opaque_auth(0);
                break;
            }
            default: {
                throw new IOException(String.valueOf(this.getClass().getName()) + ": bad security level");
            }
        }
        this.security = n;
        if (trace) {
            System.err.println("security set to " + n);
        }
        this.my_xdrs = false;
        this.xdrs = null;
    }

    public synchronized void cleanup() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public abstract void clnt_call(int var1, xdrout_upcall var2, xdrin_upcall var3) throws IOException;

    public synchronized void close() throws IOException {
        this.close_called = true;
        if (this.my_xdrs) {
            if (trace_close) {
                System.err.println("rpc_client: closing xdrs");
            }
            this.xdrs.close();
        }
        this.xdrs = null;
    }

    protected void conninit(xdr_basic xdr_basic2, boolean bl, long l, long l2) {
        this.call_msg = new rpc_msg();
        this.call_msg.ru = new rpc_msg_u();
        this.call_msg.ru.rm_direction = new msg_type();
        msg_type cfr_ignored_0 = this.call_msg.ru.rm_direction;
        this.call_msg.ru.rm_direction.value = 0;
        this.call_msg.ru.rm_direction__rm_cmb = new call_body();
        this.call_msg.ru.rm_direction__rm_cmb.cb_rpcvers = 2L;
        this.call_msg.ru.rm_direction__rm_cmb.cb_prog = l;
        this.call_msg.ru.rm_direction__rm_cmb.cb_vers = l2;
        this.call_msg.ru.rm_direction__rm_cmb.cb_cred = this.cred;
        this.call_msg.ru.rm_direction__rm_cmb.cb_verf = this.verf;
        this.xdrs = xdr_basic2;
        this.my_xdrs = bl;
    }

    public synchronized boolean get_assert_full_frame() {
        return this.xdrs.get_assert_full_frame();
    }

    protected static rpc_msg get_rply(xdr_basic xdr_basic2, long l) throws IOException {
        rpc_msg rpc_msg2;
        block23: {
            block18: while (true) {
                rpc_msg2 = new rpc_msg(xdr_basic2);
                if (trace) {
                    System.err.println("rpc_msg.xdrin: [0] got XID " + rpc_msg2.rm_xid);
                    System.err.println("rpc_msg.xdrin: [1] got direction " + rpc_msg2.ru.rm_direction.value);
                    System.err.println("rpc_msg.xdrin: [2] got rp_stat " + rpc_msg2.ru.rm_direction__rm_rmb.rp_stat.value);
                }
                switch (rpc_msg2.ru.rm_direction.value) {
                    case 0: {
                        System.err.println("clnt_call: callback not supported");
                        break;
                    }
                    default: {
                        System.err.println("clnt_call: bogus rm_directon");
                        continue block18;
                    }
                    case 1: 
                }
                if (rpc_msg2.rm_xid == l) break;
            }
            reply_body_u reply_body_u2 = rpc_msg2.ru.rm_direction__rm_rmb;
            String string = "";
            switch (reply_body_u2.rp_stat.value) {
                case 1: {
                    if (trace) {
                        System.err.println("rj_stat = " + reply_body_u2.rp_stat__rp_dr.rj_stat.value);
                        switch (reply_body_u2.rp_stat__rp_dr.rj_stat.value) {
                            case 0: {
                                string = " RPC_MISMATCH: vers = " + reply_body_u2.rp_stat__rp_dr.rj_stat__rj_version.low + ".." + reply_body_u2.rp_stat__rp_dr.rj_stat__rj_version.high;
                                if (!trace) break;
                                System.err.println(string);
                                break;
                            }
                            case 1: {
                                string = " AUTH_ERROR: why = " + reply_body_u2.rp_stat__rp_dr.rj_stat__rj_why.value;
                                if (!trace) break;
                                System.err.println(string);
                                break;
                            }
                        }
                    }
                    throw new MsgDeniedException("rj_stat = " + reply_body_u2.rp_stat__rp_dr.rj_stat.value + string);
                }
                default: {
                    throw new HardErrorException("unknown rp_stat");
                }
                case 0: 
            }
            if (trace) {
                System.err.println("rpc_msg.xdrin: [3] got auth_flavor " + reply_body_u2.rp_stat__rp_ar.ar_verf.auth_flavor.value);
            }
            switch (reply_body_u2.rp_stat__rp_ar.ar_u.ar_stat.value) {
                case 1: {
                    throw new HardErrorException("PROG_UNAVAIL");
                }
                case 2: {
                    throw new HardErrorException("PROG_MISMATCH");
                }
                case 4: {
                    throw new HardErrorException("GARBAGE_ARGS");
                }
                default: {
                    if (trace) {
                        System.err.println("rpc_msg.xdrin: ar_stat " + reply_body_u2.rp_stat__rp_ar.ar_u.ar_stat);
                    }
                    throw new HardErrorException("unknown ar_stat;rpc_msg.xdrin: ar_stat " + reply_body_u2.rp_stat__rp_ar.ar_u.ar_stat);
                }
                case 0: 
            }
            if (!trace) break block23;
            System.err.println("get_rply: got XID " + rpc_msg2.rm_xid);
        }
        return rpc_msg2;
    }

    protected static synchronized long next_xid() {
        ++xid_seed;
        return xid_seed &= 0xFFFFFFFFL;
    }

    public synchronized void set_assert_full_frame(boolean bl) {
        this.xdrs.set_assert_full_frame(bl);
    }
}

