/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.onc.rpc;

import java.io.IOException;

public abstract class xdr_prim {
    static final int BYTES_PER_XDR_UNIT = 4;
    static final int XDR_UNIT_MASK = 3;
    static final long MAX_U32 = 0xFFFFFFFFL;

    public static final byte[] iton4(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static final byte[] lton8(long l) {
        byte[] byArray = new byte[8];
        int n = (int)(l >> 32);
        int n2 = (int)l;
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
        byArray[4] = (byte)(n2 >> 24);
        byArray[5] = (byte)(n2 >> 16);
        byArray[6] = (byte)(n2 >> 8);
        byArray[7] = (byte)n2;
        return byArray;
    }

    public static final byte[] ltonu4(long l) {
        byte[] byArray = new byte[4];
        int n = (int)l;
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
        return byArray;
    }

    public static final int n4toi(byte[] byArray) {
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return n;
    }

    public static final long n8tol(byte[] byArray) {
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n2 = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        long l = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        return l;
    }

    public static final long nu4tol(byte[] byArray) {
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return (long)n & 0xFFFFFFFFL;
    }

    public final boolean xdrin_bool() throws IOException {
        return this.xdrin_long() != 0;
    }

    public final int xdrin_enum() throws IOException {
        return this.xdrin_long();
    }

    public final float xdrin_float() throws IOException {
        return Float.intBitsToFloat(this.xdrin_long());
    }

    public final long xdrin_hyper() throws IOException {
        return xdr_prim.n8tol(this.xdrin_opaque(8));
    }

    public final int xdrin_int() throws IOException {
        return this.xdrin_long();
    }

    public final int xdrin_long() throws IOException {
        return xdr_prim.n4toi(this.xdrin_opaque(4));
    }

    public abstract byte[] xdrin_opaque(int var1) throws IOException;

    public final long xdrin_u_hyper() throws IOException {
        long l = xdr_prim.n8tol(this.xdrin_opaque(8));
        if (l < 0L) {
            throw new IOException("got u_hyper < 0");
        }
        return l;
    }

    public final long xdrin_u_int() throws IOException {
        return this.xdrin_u_long();
    }

    public final long xdrin_u_long() throws IOException {
        return xdr_prim.nu4tol(this.xdrin_opaque(4));
    }

    public final void xdrout_bool(boolean bl) throws IOException {
        this.xdrout_long(bl ? 1 : 0);
    }

    public final void xdrout_enum(int n) throws IOException {
        this.xdrout_long(n);
    }

    public final void xdrout_float(float f) throws IOException {
        this.xdrout_long(Float.floatToIntBits(f));
    }

    public final void xdrout_hyper(long l) throws IOException {
        this.xdrout_opaque(xdr_prim.lton8(l));
    }

    public final void xdrout_int(int n) throws IOException {
        this.xdrout_long(n);
    }

    public final void xdrout_long(int n) throws IOException {
        this.xdrout_opaque(xdr_prim.iton4(n));
    }

    public abstract void xdrout_opaque(byte[] var1) throws IOException;

    public final void xdrout_u_hyper(long l) throws IOException {
        this.xdrout_opaque(xdr_prim.lton8(l));
    }

    public final void xdrout_u_int(long l) throws IOException {
        this.xdrout_u_long(l);
    }

    public final void xdrout_u_long(long l) throws IOException {
        this.xdrout_opaque(xdr_prim.ltonu4(l));
    }
}

