/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.onc.rpc;

import com.sun.jndi.internal.onc.rpc.xdr_basic;
import com.sun.jndi.internal.onc.rpc.xdr_prim;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class xdr_vc
extends xdr_basic {
    static boolean vc_trace = false;
    static final long LAST_FRAG = Integer.MIN_VALUE;
    static final long SIZE_MASK = Integer.MAX_VALUE;
    static final int VC_BUFSIZ = 1024;
    private Socket peer;
    private boolean my_peer;
    private boolean in_lastfrag;
    private byte[] hbuf;

    public xdr_vc(String string, int n) throws IOException {
        if (xdr_basic.trace) {
            System.err.println(String.valueOf(this.getClass().getName()) + ": server \"" + string + "\" port " + n);
        }
        if (string == null || string.length() == 0) {
            throw new IOException("null/empty server name");
        }
        if (vc_trace) {
            System.err.println("xdr_vc: creating Socket(" + string + ", " + n + ")");
        }
        Socket socket = new Socket(string, n);
        if (vc_trace) {
            System.err.println("xdr_vc: socket created, local: " + socket.getLocalPort());
        }
        this.init(socket, true);
    }

    public xdr_vc(Socket socket) {
        this.init(socket, false);
    }

    public void assert_full_frame() throws IOException {
        if (!this.in_lastfrag && this.hard_assert_full_frame) {
            throw new IOException("last frag not processed");
        }
        if (this.inindex != this.inbuffer.length) {
            System.err.println("assert_full_frame: xdrin " + this.inindex + " of " + this.inbuffer.length + " bytes");
            if (this.hard_assert_full_frame) {
                throw new IOException("partial frame processed");
            }
        }
    }

    public void close() throws IOException {
        if (xdr_basic.trace) {
            System.err.println(String.valueOf(this.getClass().getName()) + ".close: call");
        }
        this.close_called = true;
        if (this.my_peer) {
            if (vc_trace) {
                System.err.println("xdr_vc: closing socket, local: " + this.peer.getLocalPort());
            }
            this.peer.close();
        }
        this.peer = null;
    }

    protected void fillbuf() throws IOException {
        if (xdr_basic.trace) {
            System.err.println(String.valueOf(this.getClass().getName()) + ".fillbuf: reading header bytes");
        }
        if (this.in_lastfrag) {
            throw new IOException("fillbuf after LASTFRAG");
        }
        xdr_vc.mread(this.peer.getInputStream(), this.hbuf);
        long l = xdr_prim.nu4tol(this.hbuf);
        int n = (int)(l & Integer.MAX_VALUE);
        boolean bl = this.in_lastfrag = (l & Integer.MIN_VALUE) != 0L;
        if (xdr_basic.trace) {
            System.err.print(String.valueOf(this.getClass().getName()) + ".fillbuf: payload ");
            System.err.println(n);
            System.err.print(String.valueOf(this.getClass().getName()) + ".fillbuf: lastfrag ");
            System.err.println(this.in_lastfrag);
        }
        this.inbuffer = new byte[n];
        this.inindex = 0;
        xdr_vc.mread(this.peer.getInputStream(), this.inbuffer);
        if (xdr_basic.trace) {
            System.err.print(String.valueOf(this.getClass().getName()) + ".fillbuf: read ");
            System.err.println(String.valueOf(n) + " data bytes:");
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.inbuffer[n2];
                if (n3 < 0) {
                    n3 += 256;
                }
                System.err.print(String.valueOf(n3) + " ");
                ++n2;
            }
            System.err.println();
        }
    }

    protected void flushbuf(boolean bl) throws IOException {
        int n = this.outindex - 4;
        long l = n;
        if (bl) {
            l |= Integer.MIN_VALUE;
        }
        this.outindex = 0;
        this.xdrout_u_long(l);
        this.outindex = n + 4;
        this.peer.getOutputStream().write(this.outbuffer, 0, n + 4);
        if (xdr_basic.trace) {
            System.err.print(String.valueOf(this.getClass().getName()) + ".flushbuf: wrote ");
            System.err.println(String.valueOf(n) + " + 4 bytes:");
            System.err.print("[ ");
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.outbuffer[4 + n2];
                if (n3 < 0) {
                    n3 += 256;
                }
                System.err.print(String.valueOf(Integer.toString(n3, 16)) + " ");
                ++n2;
            }
            System.err.println(" ]");
        }
    }

    protected void init(Socket socket, boolean bl) {
        this.outbuffer = new byte[1024];
        this.outindex = 0;
        this.reset_inrecord();
        this.reset_outrecord();
        this.peer = socket;
        this.my_peer = bl;
        this.hbuf = new byte[4];
    }

    private static void mread(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            if (xdr_basic.trace) {
                System.err.println("xdr_stream.mread: offset=" + n + ", count=" + (byArray.length - n));
            }
            int n2 = inputStream.read(byArray, n, byArray.length - n);
            if (xdr_basic.trace) {
                System.err.println("xdr_stream.mread: got " + n2 + " of " + byArray.length + " bytes");
            }
            if (n2 <= 0) {
                throw new EOFException("xdr_stream.mread: EOF (cc is " + n2 + ")");
            }
            n += n2;
        }
    }

    protected void reset_inrecord() {
        this.in_lastfrag = false;
        this.inbuffer = null;
        this.inindex = 0;
    }

    public void reset_outrecord() {
        this.outindex = 4;
    }

    public void send_record() throws IOException {
        this.flushbuf(true);
        this.reset_outrecord();
    }
}

