/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.KeyValuePair;
import com.sun.jndi.nis.NISAttrGetter;
import com.sun.jndi.nis.NISMap;
import com.sun.jndi.nis.NISNameParser;
import com.sun.jndi.nis.NISObject;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.dir.ContainmentFilter;
import com.sun.jndi.toolkit.dir.LazySearchEnumerationImpl;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;

class NISCtx
extends ComponentDirContext
implements NISAttrGetter {
    private static final NameParser parser = new NISNameParser();
    protected static final boolean caseIgnore = true;
    private static final String[] defaultAttrIDs = new String[]{"objectclass", "cn", "nisMapEntry", "nisMapName", "description"};
    protected Hashtable environment;
    protected String mapname;
    protected String realMapname;
    protected String domainName;
    protected String hostName;
    private NISMap nismap;
    protected Attribute objectclass = new BasicAttribute("objectClass", "top");
    protected static final char AND_TOKEN = '&';
    protected static final char EQUAL_TOKEN = '=';
    protected static final char OPEN_PAREN = '(';
    protected static final char CLOSE_PAREN = ')';
    protected static final char OR_TOKEN = '|';
    protected static final char NOT_TOKEN = '!';
    protected static final char APPROX_TOKEN = '~';
    protected static final char LESS_TOKEN = '<';
    protected static final char GREATER_TOKEN = '>';
    protected static final char EXTEND_TOKEN = ':';
    protected static final char WILDCARD_TOKEN = '*';
    static /* synthetic */ Class class$com$sun$jndi$nis$NISObject;

    public NISCtx() {
        this.objectclass.add("nisObject");
    }

    NISCtx(String string, String string2, String string3, Hashtable hashtable) throws NamingException {
        this.init(string, string2, string3, hashtable);
        this.objectclass.add("nisObject");
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.environment = this.environment == null ? new Hashtable(5, 0.75f) : (Hashtable)this.environment.clone();
        return this.environment.put(string, object);
    }

    protected void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this.getMapAttributes(stringArray);
        }
        NISMap nISMap = this.getNISMap();
        String string = name.toString();
        String string2 = this.getEntry(nISMap, string, stringArray);
        Attributes attributes = this.getAttributesFromEntry(string, string2, stringArray);
        continuation.setSuccess();
        return attributes;
    }

    protected NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return parser;
        }
        Object object = this.c_lookup(name, continuation);
        continuation.setContinue(object, name, this);
        return null;
    }

    protected DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        return null;
    }

    protected DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        return null;
    }

    protected NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            NISMap nISMap = this.getNISMap();
            continuation.setSuccess();
            return this.getNameClassList(nISMap.getAllEntries());
        }
        Object object = this.c_lookup(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            NISMap nISMap = this.getNISMap();
            continuation.setSuccess();
            return this.getBindingList(nISMap.getAllEntries(), true);
        }
        Object object = this.c_lookup(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this;
        }
        NISMap nISMap = this.getNISMap();
        String string = name.toString();
        String string2 = nISMap.getEntry(string);
        continuation.setSuccess();
        NISObject nISObject = new NISObject(this, string, string2, this.environment);
        try {
            Attributes attributes = this.getAttributesFromEntry(string, string2, null);
            return DirectoryManager.getObjectInstance(nISObject, name, this, this.environment, attributes);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("problem generating object using object factory");
            namingException.setRootCause(exception);
            throw continuation.fillInException(namingException);
        }
    }

    protected Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    protected void c_modifyAttributes(Name name, int n, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        NISMap nISMap = this.getNISMap();
        if (searchControls == null) {
            searchControls = new SearchControls();
        }
        if (searchControls.getSearchScope() == 2) {
            continuation.setError((Object)this, name);
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException("subtree searches not supported");
            throw continuation.fillInException(operationNotSupportedException);
        }
        if (this.isConjunctionOnly(string) && searchControls.getSearchScope() == 1 && !searchControls.getReturningObjFlag()) {
            return this.c_search(name, this.conjunctionToAttributes(string), searchControls.getReturningAttributes(), continuation);
        }
        SearchFilter searchFilter = new SearchFilter(string);
        if (name.isEmpty()) {
            if (searchControls.getSearchScope() == 1) {
                return new LazySearchEnumerationImpl(this.getBindingList(nISMap.getAllEntries(), false), searchFilter, searchControls, this, this.environment);
            }
            Attributes attributes = this.getMapAttributes(null);
            if (searchFilter.check(attributes)) {
                SearchResult searchResult = new SearchResult("", (Object)(searchControls.getReturningObjFlag() ? this : null), SearchFilter.selectAttributes(attributes, searchControls.getReturningAttributes()));
                return new SearchEnumerationImpl(searchResult);
            }
        } else {
            Attributes attributes;
            String string2 = name.toString();
            String string3 = this.getEntry(nISMap, string2, null);
            if (searchControls.getSearchScope() != 1 && searchFilter.check(attributes = this.getAttributesFromEntry(string2, string3, null))) {
                Object object = null;
                if (searchControls.getReturningObjFlag()) {
                    object = new NISObject(this, string2, string3, this.environment);
                    try {
                        object = DirectoryManager.getObjectInstance(object, name, this, this.environment, attributes);
                    }
                    catch (NamingException namingException) {
                        throw continuation.fillInException(namingException);
                    }
                    catch (Exception exception) {
                        NamingException namingException = new NamingException("problem generating object using object factory");
                        namingException.setRootCause(exception);
                        throw continuation.fillInException(namingException);
                    }
                }
                SearchResult searchResult = new SearchResult(string2, object, SearchFilter.selectAttributes(attributes, searchControls.getReturningAttributes()));
                return new SearchEnumerationImpl(searchResult);
            }
        }
        return new SearchEnumerationImpl();
    }

    protected NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        String string2 = SearchFilter.format(string, objectArray);
        return this.c_search(name, string2, searchControls, continuation);
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            boolean bl;
            Attribute attribute = this.getPrimaryAttribute(attributes = NISCtx.makeCaseIgnore(attributes));
            if (attribute != null) {
                String string = (String)attribute.get();
                try {
                    NISMap nISMap = this.getNISMap();
                    String string2 = this.getEntry(nISMap, string, null);
                    Attributes attributes2 = this.getAttributesFromEntry(string, string2, null);
                    if (ContainmentFilter.contains(attributes2, attributes)) {
                        String string3 = this.getNameFromEntry(string, attributes2);
                        SearchResult searchResult = new SearchResult(string3, (Object)null, SearchFilter.selectAttributes(attributes2, stringArray));
                        return new SearchEnumerationImpl(searchResult);
                    }
                }
                catch (NamingException namingException) {}
                return new SearchEnumerationImpl();
            }
            Attribute attribute2 = this.getSecondaryAttribute(attributes);
            if (attribute2 != null) {
                String string = (String)attribute2.get();
                try {
                    NISMap nISMap = new NISMap(this.domainName, this.hostName, this.getSecondaryMapname());
                    String string4 = nISMap.getEntry(string);
                    Attributes attributes3 = this.getAttributesFromEntry(null, string4, null);
                    if (ContainmentFilter.contains(attributes3, attributes)) {
                        String string5 = (String)attributes3.get(this.getEntryName()).get();
                        SearchResult searchResult = new SearchResult(string5, (Object)null, SearchFilter.selectAttributes(attributes3, stringArray));
                        return new SearchEnumerationImpl(searchResult);
                    }
                }
                catch (NamingException namingException) {}
                return new SearchEnumerationImpl();
            }
            NISMap nISMap = this.getNISMap();
            String[] stringArray2 = this.getIDs();
            boolean bl2 = bl = attributes == null || attributes.size() == 0;
            if (!bl) {
                int n = 0;
                while (n < stringArray2.length && !bl) {
                    if (attributes.get(stringArray2[n]) != null) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    stringArray2 = this.getDefaultIDs();
                    int n2 = 0;
                    while (n2 < stringArray2.length && !bl) {
                        if (attributes.get(stringArray2[n2]) != null) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (!bl) {
                return new SearchEnumerationImpl();
            }
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(stringArray);
            return new LazySearchEnumerationImpl(this.getBindingList(nISMap.getAllEntries(), false), new ContainmentFilter(attributes), searchControls, this, this.environment);
        }
        NISMap nISMap = this.getNISMap();
        String string = name.toString();
        String string6 = nISMap.getEntry(string);
        return new SearchEnumerationImpl();
    }

    protected void c_unbind(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw continuation.fillInException(operationNotSupportedException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws NamingException {
        this.finalize();
    }

    /*
     * Unable to fully structure code
     */
    protected Attributes conjunctionToAttributes(String var1_1) throws NamingException {
        var2_2 = new BasicAttributes(true);
        var3_3 = 0;
        var4_4 = var1_1.length();
        var5_5 = 0;
        ** GOTO lbl42
        {
            ++var3_3;
            do {
                if (Character.isWhitespace(var1_1.charAt(var3_3)) && var3_3 < var4_4) continue block5;
                if (var3_3 >= var4_4) break block5;
                var11_11 = var1_1.charAt(var3_3);
                switch (var11_11) {
                    case '(': {
                        ++var5_5;
                        ++var3_3;
                        break;
                    }
                    case '&': {
                        ++var3_3;
                        break;
                    }
                    case ')': {
                        --var5_5;
                        ++var3_3;
                        break;
                    }
                    default: {
                        var8_8 = var1_1.indexOf(41, var3_3);
                        if (var8_8 < 0) {
                            if (var5_5 == 0) {
                                var8_8 = var4_4;
                            } else {
                                throw new InvalidSearchFilterException("unbalanced parenthesis: " + var1_1);
                            }
                        }
                        if ((var7_7 = var1_1.indexOf(61, var3_3)) < 0) {
                            throw new InvalidSearchFilterException("missing equal sign: " + var1_1);
                        }
                        var9_9 = var1_1.substring(var3_3, var7_7).trim();
                        var10_10 = var1_1.substring(var7_7 + 1, var8_8).trim();
                        var6_6 = var2_2.get(var9_9);
                        if (var6_6 != null) {
                            var6_6.add(var10_10);
                        } else {
                            var2_2.put(var9_9, var10_10);
                        }
                        var3_3 = var8_8;
                    }
                }
lbl42:
                // 5 sources

            } while (var3_3 < var4_4);
        }
        if (var5_5 != 0) {
            throw new InvalidSearchFilterException("unbalanced parenthesis: " + var1_1);
        }
        if (var2_2.size() == 0) {
            throw new InvalidSearchFilterException("empty filter");
        }
        return var2_2;
    }

    protected void finalize() {
        this.environment = null;
        if (this.nismap != null) {
            this.nismap.close();
        }
        this.nismap = null;
    }

    protected static int findId(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static Attributes fixDescription(Attributes attributes) throws NamingException {
        Attribute attribute = attributes.get("description");
        if (attribute != null) {
            String string = (String)attribute.get();
            string = string.charAt(0) == '#' ? string.substring(1).trim() : string.trim();
            if (string.length() == 0) {
                attributes.remove("description");
            } else {
                attribute.clear();
                attribute.add(string);
            }
        }
        return attributes;
    }

    public Attributes getAttributesFromEntry(String string, String string2, String[] stringArray) throws NamingException {
        boolean bl = stringArray == null;
        BasicAttributes basicAttributes = new BasicAttributes(true);
        if (!bl && stringArray.length == 0) {
            return basicAttributes;
        }
        String string3 = null;
        if (string == null && (string3 = this.getEntryName()) != null && string3.equals("cn")) {
            string3 = null;
        }
        String string4 = null;
        String[] stringArray2 = this.getIDs();
        String[] stringArray3 = this.parseEntry(string2, stringArray2.length);
        int n = 0;
        while (n < stringArray2.length) {
            if ((bl || NISCtx.findId(stringArray, stringArray2[n]) >= 0) && stringArray3[n] != null) {
                basicAttributes.put(stringArray2[n], stringArray3[n]);
            }
            if (string3 != null && string3.equals(stringArray2[n])) {
                string4 = stringArray3[n];
            }
            ++n;
        }
        if (bl || NISCtx.findId(stringArray, "nisMapEntry") >= 0) {
            basicAttributes.put("nisMapEntry", string2);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapName") >= 0) {
            basicAttributes.put("nisMapName", this.realMapname);
        }
        if (bl || NISCtx.findId(stringArray, "objectClass") >= 0) {
            basicAttributes.put(this.objectclass);
        }
        if (basicAttributes.get("cn") == null && (bl || NISCtx.findId(stringArray, "cn") >= 0)) {
            if (string != null) {
                basicAttributes.put("cn", string);
            } else if (string4 != null) {
                basicAttributes.put("cn", string4);
            }
        }
        return basicAttributes;
    }

    protected NamingEnumeration getBindingList(NamingEnumeration namingEnumeration, boolean bl) {
        return new NISBindingList(namingEnumeration, bl);
    }

    protected String[] getDefaultIDs() {
        return defaultAttrIDs;
    }

    protected String getEntry(NISMap nISMap, String string, String[] stringArray) throws NamingException {
        return nISMap.getEntry(string);
    }

    protected String getEntryName() {
        return null;
    }

    protected String getEntrySeparator() {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable(5);
        }
        return (Hashtable)this.environment.clone();
    }

    protected String[] getIDs() {
        return new String[0];
    }

    protected Attributes getMapAttributes(String[] stringArray) {
        boolean bl = stringArray == null;
        BasicAttributes basicAttributes = new BasicAttributes(true);
        if (bl || NISCtx.findId(stringArray, "objectClass") >= 0) {
            BasicAttribute basicAttribute = new BasicAttribute("objectClass", "nisMap");
            basicAttribute.add("top");
            basicAttributes.put(basicAttribute);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapName") >= 0) {
            basicAttributes.put("nisMapName", this.getMapname());
        }
        return basicAttributes;
    }

    protected String getMapname() {
        if (this.realMapname != null) {
            return this.realMapname;
        }
        try {
            if (NISMap.checkMap(this.domainName, this.hostName, this.mapname)) {
                this.realMapname = this.mapname;
                return this.realMapname;
            }
            if (NISMap.checkMap(this.domainName, this.hostName, String.valueOf(this.mapname) + ".byname")) {
                this.realMapname = String.valueOf(this.mapname) + ".byname";
                return this.realMapname;
            }
        }
        catch (NamingException namingException) {}
        return this.mapname;
    }

    protected synchronized NISMap getNISMap() {
        if (this.nismap != null) {
            return this.nismap;
        }
        this.nismap = new NISMap(this.domainName, this.hostName, this.getMapname());
        return this.nismap;
    }

    protected NamingEnumeration getNameClassList(NamingEnumeration namingEnumeration) {
        return new NISNCList(namingEnumeration);
    }

    protected String getNameFromEntry(String string, Attributes attributes) throws NamingException {
        return string;
    }

    public String getNameInNamespace() {
        return this.mapname;
    }

    Attribute getPrimaryAttribute(Attributes attributes) {
        if (attributes != null) {
            return attributes.get("cn");
        }
        return null;
    }

    Attribute getSecondaryAttribute(Attributes attributes) {
        return null;
    }

    protected String getSecondaryMapname() {
        return null;
    }

    void init(String string, String string2, String string3, Hashtable hashtable) throws NamingException {
        this.environment = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.domainName = string;
        this.hostName = string2;
        if (this.domainName == null) {
            throw new ConfigurationException("Unspecified NIS domainname");
        }
        this.initMapname(string3);
    }

    protected void initMapname(String string) {
        this.mapname = string;
        if (string.indexOf(46) >= 0) {
            this.realMapname = string;
        }
    }

    protected boolean isConjunctionOnly(String string) {
        return string.indexOf(124) < 0 && string.indexOf(33) < 0 && string.indexOf(126) < 0 && string.indexOf(60) < 0 && string.indexOf(62) < 0 && string.indexOf(58) < 0 && string.indexOf(42) < 0;
    }

    protected static Attributes makeCaseIgnore(Attributes attributes) {
        if (attributes == null || attributes.isCaseIgnored()) {
            return attributes;
        }
        BasicAttributes basicAttributes = new BasicAttributes(true);
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            basicAttributes.put((Attribute)namingEnumeration.nextElement());
        }
        return basicAttributes;
    }

    protected Hashtable p_getEnvironment() {
        return this.environment;
    }

    protected String[] parseEntry(String string, int n) {
        String string2 = this.getEntrySeparator();
        String[] stringArray = new String[n];
        if (string2 == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.hasMoreElements() ? (n2 == n - 1 ? stringTokenizer.nextToken("\n").trim() : stringTokenizer.nextToken()) : null;
                ++n2;
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            int n3 = 0;
            boolean bl = true;
            while (n3 < n && stringTokenizer.hasMoreElements()) {
                String string3 = bl && n3 == n - 1 ? stringTokenizer.nextToken("\n") : stringTokenizer.nextToken();
                if (string2.indexOf(string3) < 0) {
                    stringArray[n3++] = string3;
                    bl = false;
                    continue;
                }
                if (bl) {
                    stringArray[n3++] = null;
                    continue;
                }
                bl = true;
            }
            int n4 = n3;
            while (n4 < n) {
                stringArray[n4] = null;
                ++n4;
            }
        }
        return stringArray;
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.environment != null && this.environment.get(string) != null) {
            this.environment = (Hashtable)this.environment.clone();
            return this.environment.remove(string);
        }
        return null;
    }

    class NISNCList
    implements NamingEnumeration {
        protected NamingEnumeration keyvalues;

        NISNCList(NamingEnumeration namingEnumeration) {
            this.keyvalues = namingEnumeration;
        }

        public void close() {
            this.keyvalues = null;
        }

        public boolean hasMore() throws NamingException {
            return this.keyvalues.hasMore();
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException namingException) {
                return false;
            }
        }

        public Object next() throws NamingException {
            KeyValuePair keyValuePair = (KeyValuePair)this.keyvalues.next();
            String string = (class$com$sun$jndi$nis$NISObject != null ? class$com$sun$jndi$nis$NISObject : (class$com$sun$jndi$nis$NISObject = NISCtx.class$("com.sun.jndi.nis.NISObject"))).getName();
            return new NameClassPair(keyValuePair.getKey(), string);
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }
    }

    class NISBindingList
    extends NISNCList {
        private boolean callNamingManager;

        NISBindingList(NamingEnumeration namingEnumeration, boolean bl) {
            super(namingEnumeration);
            this.callNamingManager = bl;
        }

        public Object next() throws NamingException {
            KeyValuePair keyValuePair = (KeyValuePair)this.keyvalues.next();
            Object object = new NISObject(NISCtx.this, keyValuePair.getKey(), keyValuePair.getValue(), NISCtx.this.environment);
            if (this.callNamingManager) {
                try {
                    CompositeName compositeName = new CompositeName();
                    compositeName.add(keyValuePair.getKey());
                    Attributes attributes = NISCtx.this.getAttributesFromEntry(keyValuePair.getKey(), keyValuePair.getValue(), null);
                    object = DirectoryManager.getObjectInstance(object, compositeName, NISCtx.this, NISCtx.this.environment, attributes);
                }
                catch (NamingException namingException) {
                    throw namingException;
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("problem generating object using object factory");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
            }
            return new Binding(keyValuePair.getKey(), object);
        }
    }

    static class SearchEnumerationImpl
    implements NamingEnumeration {
        SearchResult answer = null;

        SearchEnumerationImpl() {
        }

        SearchEnumerationImpl(SearchResult searchResult) {
            this.answer = searchResult;
        }

        public void close() {
            this.answer = null;
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.answer != null;
        }

        public Object next() throws NamingException {
            if (this.answer != null) {
                SearchResult searchResult = this.answer;
                this.answer = null;
                return searchResult;
            }
            throw new NoSuchElementException();
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }
    }
}

